<?php
class TW_WIDGET_ProductSearch extends \Elementor\Widget_Base {


	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);

        $sliderStyle = dirname(get_stylesheet_uri()) . '/assets/css/rangeSlider.css';
        wp_register_style('rangeSlider', $sliderStyle);

        $sliderScript = dirname(get_stylesheet_uri()) . '/assets/js/rangeSlider.js';
        wp_register_script('rangeSlider', $sliderScript);

		$style_url = dirname(get_stylesheet_uri()) . '/widgets/productSearch/style.css';
		wp_register_style('productSearchStyle', $style_url);
	}

	public function get_style_depends() {
		return ['rangeSlider', 'productSearchStyle'];
	}

    public function get_script_depends()
    {
        return ['rangeSlider'];
    }

	protected function is_dynamic_content(): bool {
		return true;
	}

	public function get_name() {
		return 'tw_productsearch';
	}

	public function get_title() {
		return esc_html__( 'Recherche de produits', 'tw-theme' );
	}

	public function get_icon() {
		return 'eicon-search';
	}

	public function get_categories() {
		return [ 'woocommerce-elements-single' ];
	}

	public function get_keywords() {
		return ['product', 'search'];
	}

    /*
    requêtte
    http://local.boutiquerando2.fr/product-category/vetement/?e-page-47bae82=3

    anuller la requête automatique 
    la faire moi même en ajoutant des paramètres supplémentaires
    puisse prendre en compte ces paramètres dans le résultat de la requête

    Hook utilisé pour la requêtte c'est elementor/query/query_results

    voir elementor-pro/modules/posts/widgets/posts-base.php->get_posts_nav_link (mettre un get_class dedans)
    il faudra overloader le widget
    */
	protected function render() {
        global $wp_query;
        $currentCategory = $wp_query->get('product_cat');

        $categories = [];
        $categoriesTermTaxonomyIds = [];

        if($currentCategory !== null){
            $categories = TW_Factory::getInstance()->getClass(TW_Product_Repository::class)->getCategoriesSlugWithChild($currentCategory);
            foreach($categories as $slug => $item) {
                $categoriesTermTaxonomyIds[] = $item['term_taxonomy_id'];
            }
        }

        $templatePath = realpath(__DIR__. '/template.php');
        $templateVars = [
            'pageUrl' => $_SERVER["REQUEST_SCHEME"] . '://' . $_SERVER["SERVER_NAME"] . $_SERVER["REQUEST_URI"],
            'ajaxUrl' => $_SERVER["REQUEST_SCHEME"] . '://' . $_SERVER["SERVER_NAME"] . '/wp-admin/admin-ajax.php?action=ajax_product_search',
            'nbrProducts' => $wp_query->found_posts,
            'productCategory' => $currentCategory,
            'customAttributes' => TW_Factory::getInstance()->getClass(TW_Product_Repository::class)->getCustomAttributesList('SLUG', $categoriesTermTaxonomyIds),
            'customTaxonomies' => TW_Factory::getInstance()->getClass(TW_Product_Repository::class)->getCustomTaxonomyList('SLUG', $categoriesTermTaxonomyIds),
            'isCategory' => false,
            'currentCategoryName' => "",
            'categoryChilds' => 0,
            'categories' => [],
            'min' => 0,
            'max' => 500
        ];

        if($currentCategory !== null){
            $templateVars['currentCategoryName'] = $categories[$currentCategory]['name'];
            $templateVars['isCategory'] = true;
            $templateVars['categories'] = $categories;
        }

        $params = [];
        foreach($_GET as $key => $value) {
            if(
                in_array($key, ['s_price', 'priceMin', 'priceMax'])
                && strchr($_GET['s_price'], ',') !== false
                && !isset($params['s_price'])
            ){
                $min = explode(',', $_GET['s_price'])[0];
                $max = explode(',', $_GET['s_price'])[1];

                $params['price'] = $_GET['s_price'];
                $params['priceMin'] = explode(',', $_GET['s_price'])[0];
                $params['priceMax'] = explode(',', $_GET['s_price'])[1];
            } else if(!in_array($key, ['action'])){
                if(!empty($value)){
                    $key = str_replace('s_', '', $key);
                    $params[$key] = stripslashes($value);
                }
            }
        }
        $templateVars['params'] = $params;

        ob_start();
        load_template($templatePath, false, $templateVars);
        $tplContent = ob_get_contents();
        ob_end_clean();

        echo $tplContent;
	}
}