<?php
use Elementor\Widget_Heading;

class TW_WIDGET_Heading extends Widget_Heading {
    protected function register_controls()
    {
        parent::register_controls();
        $this->add_control(
            'variations',
            [
                'section' => 'section_title',
                'label' => esc_html__( 'Variations', 'elementor'),
                'type' => 'select',
                'options' => [
                    '' => esc_html__( 'Sans variations', 'twcommerce-theme'),
                    'title_variation_1' => esc_html__( 'Avec logo', 'twcommerce-theme')
                ],
                'default' => ''
            ]
        );
    }

    protected function render(){
        $settings = $this->get_settings_for_display();

        if($settings['variations'] == 'title_variation_1') {
            $this->add_render_attribute('_wrapper', 'class', 'has_title_variations');
            $this->add_render_attribute('title', 'class', 'title_variation_1');
        }
        parent::render();
    }

    protected function content_template(){
        ?>
        <#
        if (settings.variations == 'title_variation_1') {
            view.el.classList.add('has_title_variations');
            view.addRenderAttribute('title', 'class', ['title_variation_1']);
        } else {
            view.el.classList.remove('has_title_variations');
        }
        #>

        <?php
        parent::content_template();
    }
}