<?php
class TW_WIDGET_CustomVariable extends \Elementor\Widget_Base {


	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);

        /*
		$style_url = dirname(get_stylesheet_uri()) . '/widgets/productVariationSelector/style.css';
		wp_register_style('productVariationSelectorStyle', $style_url);
        */
	}

    protected function register_controls()
    {
        $this->start_controls_section(
			'section_variable',
			[
				'label' => esc_html__( 'Variable', 'tw-theme' ),
			]
		);

        $this->add_control(
            'variable',
            [
                'label' => esc_html__( 'Variable à afficher', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Variable à afficher', 'tw-theme' ),
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'prefix',
            [
                'label' => esc_html__( 'Préfixe', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Préfixe', 'tw-theme' ),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();
    }

	protected function is_dynamic_content(): bool {
		return true;
	}

	public function get_name() {
		return 'tw_customvariable';
	}

	public function get_title() {
		return esc_html__( 'Variables personalisés', 'tw-theme' );
	}

	public function get_icon() {
		return 'eicon-code';
	}

	public function get_categories() {
		return [ 'theme-elements' ];
	}

	public function get_keywords() {
		return ['custom', 'variable'];
	}

	public function dynamic_parser($tag_id, $tag_name, array $settings = []) {
		return \Elementor\Plugin::$instance->dynamic_tags->get_tag_data_content($tag_id, $tag_name, $settings);
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$prefixe = isset($settings['prefix']) ? $settings['prefix'] : null;
		$variable = isset($settings['variable']) ? $settings['variable'] : '';
		$dynamicValue = null;

		$content = "";
		if($prefixe !== null) {
			$content .= "<span class=\"prefixe\">" . $prefixe . "</span>";
		}

		$dynamicSettings = $this->get_parsed_dynamic_settings();
		$currentDynamicSettings = $this->get_settings('dynamic');
		if (is_array($currentDynamicSettings)) {
			$dynamicSettings = array_merge($currentDynamicSettings, $dynamicSettings);
		}

		if(isset($settings['__dynamic__']['variable'])){
			$resolutionFailed = false;
			$dynamicValue = \Elementor\Plugin::$instance->dynamic_tags->parse_tags_text(
				$settings['__dynamic__']['variable'], 
				$dynamicSettings,
				function($tag_id, $tag_name, array $settings = []) use (&$resolutionFailed) {
					if(is_admin() && preg_match('/product/', $tag_name) != false && (!isset($GLOBALS['product']) || $GLOBALS['product']) === false) {
						$resolutionFailed = true;
						return false;
					}

					return \Elementor\Plugin::$instance->dynamic_tags->get_tag_data_content($tag_id, $tag_name, $settings);
				}
			);
			
			if($resolutionFailed === true) {
				return;
			}
		}

		$content .= "<span class=\"variable\">" . $dynamicValue . "</span>";
        echo $content;
	}
}