<?php

class TW_Elementor_Tag_Brand_Slide_Url extends \Elementor\Core\DynamicTags\Data_Tag
{
    public function get_name() {
		return 'TW_Elementor_Tag_Brand_Slide_Url';
	}

    public function get_title() {
		return esc_html__( 'Brand slide url', 'tw' );
	}

    public function get_group() {
		return 'brand';
	}

    public function get_categories()
    {
        return ['url'];
    }

    public function get_value(array $options = [])
    {
        global $post;
        $brandName = $post->post_name;

        $linkUrl = get_term_link('vetement', 'product_cat');
        $linkUrl .= "?s_brand=" . $brandName;

        return $linkUrl;
    }
}