<?php
function tw_carousel_dynamiccss($widget){
    if(is_admin()){
        return;
    }

    if($widget->get_name() == "loop-carousel") {
        $slidesToShow = null;
        $slidesToShowTablet = null;
        $slidesToShowMobile = null;
        $numberOfSlides = null;

        $id = $widget->get_id();
        $breakpoints = \Elementor\Plugin::$instance->breakpoints->get_active_breakpoints();
        $styleSheetGenerator = new TW_Stylesheet();

        if($widget->get_settings("slides_to_show_mobile") !== null 
            && filter_var($widget->get_settings("slides_to_show_mobile"), FILTER_VALIDATE_INT) !== false) {
            $slidesToShowMobile = filter_var($widget->get_settings("slides_to_show_mobile"), FILTER_VALIDATE_INT);
        }

        if($widget->get_settings("slides_to_show_tablet") !== null 
            && filter_var($widget->get_settings("slides_to_show_tablet"), FILTER_VALIDATE_INT) !== false) {
            $slidesToShowTablet = filter_var($widget->get_settings("slides_to_show_tablet"), FILTER_VALIDATE_INT);
        }

        if($widget->get_settings("slides_to_show") !== null 
            && filter_var($widget->get_settings("slides_to_show"), FILTER_VALIDATE_INT) !== false) {
            $slidesToShow = filter_var($widget->get_settings("slides_to_show"), FILTER_VALIDATE_INT);
        }


        if($widget->get_settings("posts_per_page") !== null
            && filter_var($widget->get_settings("posts_per_page"), FILTER_VALIDATE_INT) !== false) {
            $numberOfSlides = filter_var($widget->get_settings("posts_per_page"), FILTER_VALIDATE_INT);
        }

        if($slidesToShowMobile !== null) {
            $maxWidth = round((1 / $slidesToShowMobile) * 100);
            $breakPointThreshold = 0;

            //.e-loop-item'
            $styleSheetGenerator->addMediaRules(
                '.elementor-element-' . $id . ' .e-loop-item',
                '@media(width > ' . $breakPointThreshold . 'px )',
                [
                    'max-width' => $maxWidth . '%'
                ]
            );
        }

        if($slidesToShowTablet !== null) {
            $maxWidth = ((1 /  $slidesToShowTablet) *  100);
            $maxWidth = round($maxWidth);
            $breakPointThreshold = $breakpoints['mobile']->get_value();
            
            $styleSheetGenerator->addMediaRules(
                '.elementor-element-' . $id . ' .e-loop-item',
                '@media(width > ' . $breakPointThreshold . 'px )',
                [
                    'max-width' => $maxWidth . '%'
                ]
            );
        }

        if($slidesToShow !== null) {
            $maxWidth = ((1 /  $slidesToShow) *  100);
            $breakPointThreshold = $breakpoints['tablet']->get_value();
            
            $styleSheetGenerator->addMediaRules(
                '.elementor-element-' . $id . ' .e-loop-item',
                '@media(width > ' . $breakPointThreshold . 'px )',
                [
                    'max-width' => $maxWidth . '%'
                ]
            );
        }

        $generatedStyleSheet = '<style type="text/css">' . $styleSheetGenerator->generateStyleSheet() . '</style>';
        echo $generatedStyleSheet;
    }
}
add_action('elementor/widget/before_render_content', 'tw_carousel_dynamiccss', PHP_INT_MAX, 2);
