<?php

tw_include_files(__DIR__ . '/repository');
TW_Factory::getInstance()->instantiateClass(
    TW_Product_Repository::class,
    [
        TW_Product_Repository_Variation_Trait::class
    ]
);

tw_include_files(__DIR__ . '/includes');

add_filter('hello_elementor_page_title', function($shoudDisplayPageTitle){
    return false;
});

//custom templates
add_filter('wc_get_template', function($template, $template_name, $args, $template_path, $default_path){
    if($template_name == 'cart/mini-cart.php') {
        return __DIR__ . '/templates/mini-cart.php';
    } else if($template_name == 'checkout/form-checkout.php') {
        return __DIR__ . '/templates/form-checkout.php';
    }
    return $template;
}, PHP_INT_MAX, 5);

add_filter('the_content', function($content){
    global $wp_query;
    if($wp_query->post !== null && $wp_query->post->post_name == "checkout") {
        $content = tw_render_template(__DIR__ . '/templates/page-checkout.php');
    }
    return $content;
}, PHP_INT_MAX);

//custom menu
add_filter('elementor/widget/tw_widget_mega_menu/init', function($data){
    $productCategories =  TW_Factory::getInstance()->getClass(TW_Product_Repository::class)->getProductCategories(['vetement', 'uncategorized'], false);

    $existingCategorieNames = [];
    foreach($data['settings']['menu_items'] as $item) {
        $existingCategorieNames[] = $item['item_title'];
    }

    foreach($productCategories as $item) {
        if(!in_array($item['name'], $existingCategorieNames)){
            $data['settings']['menu_items'][] = [
                '_id' => tw_generate_random_hex(),
                'item_title' => $item['name'],
                'item_link' => [
                    'url' => get_term_link((int)$item['term_id'], 'product_cat'),
                    'is_external' => '',
                    'nofollow' => '',
                    'custom_attributes' => ''
                ]
            ];

            $data['elements'][] = [
                'id' => tw_generate_random_hex(),
                'elType' => 'container',
                'settings' => [
                    '_title' => $item['name']
                ],
                'elements' => [],
                'isInner' => true,
                'isLocked' => true
            ];
        }
    }

    return $data;
});


//custom tag
function register_tw_tags( $dynamic_tags_manager ) {
    $dynamic_tags_manager->register( new TW_Elementor_Tag_Brand_Slide_Url());
}
add_action( 'elementor/dynamic_tags/register', 'register_tw_tags' );


add_action('wp_enqueue_scripts', 'theme_enqueue_styles', 10);
function theme_enqueue_styles() {
    $styleBaseUrl = get_site_url() . '/wp-content/themes/tw-theme/';

    wp_enqueue_style('twtheme_customicon', $styleBaseUrl . '/assets/css/flaticon.css', [], false);
    wp_enqueue_style('twtheme_fontawesome', $styleBaseUrl . '/assets/css/fontawesome.min.css', [], false);
    wp_enqueue_style('parent-style', $styleBaseUrl . 'style.css', ['hello-elementor']);
    wp_enqueue_style('custom-style', $styleBaseUrl . 'custom.css');

    if(!is_admin()){
        wp_enqueue_script('front', $styleBaseUrl . 'front.js');
    }
}

add_action('elementor/init', function(){
    if(\Elementor\Plugin::$instance->experiments->is_feature_active('e_element_cache')){
        update_option('elementor_experiment-e_element_cache', 'inactive');
        \Elementor\Plugin::$instance->files_manager->clear_cache();
    }
});