<?php

if(!function_exists('tw_include_files')){
    function tw_include_files($directory, $mode = "include", $inclusionCallback = null)
    {
        $files = is_array(scandir($directory)) ? scandir($directory) : [];
        foreach($files as $file) {
            if(strpos($file, '.php') !== false) {
                $className = "TW_";
                $tmpClassName = str_replace('.php', '', $file);

                $classNameParts = explode("_", $tmpClassName);
                for($i=0;$i<count($classNameParts);$i++) {
                    if($i < count($classNameParts) - 1) {
                        $className .= ucfirst($classNameParts[$i]) . '_';
                    } else {
                        $className .= ucfirst($classNameParts[$i]);
                    }
                }

                if($mode == "require once") {
                    require_once $directory . '/' . $file;
                } else {
                    include $directory . '/' . $file;
                }

                if($inclusionCallback !== null) {
                    $inclusionCallback($className);
                }
            }
        }
    }
}

if(!function_exists('tw_single_item_or_null')){
    function tw_single_item_or_null($data){            
        if(count($data) == 1) {
            return $data[0];
        }
        return null;
    }
}

if(!function_exists("tw_execute_code_within_error_hander")){
    function tw_execute_code_within_error_hander($callback, $error_level = E_WARNING, $convertErrorIntoException = false)
    {
        $result = null;
        $errorEncountered = null;

        try {
            set_error_handler(function($errno, $errstr, $errfile, $errline) use (&$errorEncountered){
                $errorEncountered = $errno;
                return true;
            }, $error_level);
            $result = $callback();

            if($errorEncountered !== null && $convertErrorIntoException) {
                throw new \Exception("Error : " . $errorEncountered);
            }

            restore_error_handler();
            return $result;
        } catch(\Exception $ex) {
            restore_error_handler();
            throw ($ex);
        }
    }
}

if(!function_exists('tw_explode_ids')){
    function tw_explode_ids($ids){
        $exploded_ids = "";
        for($i=0;$i<count($ids);$i++){
            if($i == 0) {
                $exploded_ids .= $ids[$i];
            } else {
                $exploded_ids .= ", " . $ids[$i];
            }
        }

        return $exploded_ids;
    }
};

if(!function_exists('tw_explode_strings')){
    function tw_explode_strings($values, $escapeString = false, \PDO $pdo = null){
        $exploded_strings = "";

        if($escapeString === true && $pdo !== null) {
            for($i=0;$i<count($values);$i++){
                if($i == 0) {
                    $exploded_strings .= $pdo->quote($values[$i]);
                } else {
                    $exploded_strings .= ", " . $pdo->quote($values[$i]);
                }
            }
        } else {
            for($i=0;$i<count($values);$i++){
                if($i == 0) {
                    $exploded_strings .= "'" . $values[$i] . "'";
                } else {
                    $exploded_strings .= ", " . "'" . $values[$i] . "'";
                }
            }
        }
        return $exploded_strings;
    }
};

if(!function_exists('defined_and_not_blank')){
    function defined_and_not_blank($value){
        if(is_array($value)){
            return count($value) > 0;
        } else {
            return isset($value) && trim($value) != "";
        }
    }
}

if (!function_exists('tw_array_where') ) {
    /**
     * return null or found value
     */
    function tw_array_where($array, $property, $value) {
        $found_value = null;
        $lookup_value = $array;

        if(is_string($property)){
            $property = explode('.', $property);
        }

        if(count($property) >= 2) {
            if(!isset($lookup_value[$property[0]]) || !is_array($lookup_value[$property[0]])){
                return null;
            } else {
                $array = $lookup_value[$property[0]];
                array_shift($property);
                return tw_array_where($array, $property, $value);
            }
        }
        
        foreach($lookup_value as $inner_value) {
            if(is_callable($value)){
                if($value($inner_value) === true) {
                    $found_value = $inner_value;
                    break;
                }
            } else {
                if($inner_value[$property[0]] == $value){
                    $found_value = $inner_value;
                    break;
                }
            }
        }

        return $found_value;
    }
}

if(!function_exists('tw_parse_url')){
    function tw_parse_url($url) {
        $script_name = "";
        $params = [];
        $is_admin = is_admin();
        $post_edition = false;
        $edited_post_type = null;
        
        $url_components = parse_url($url);
        if(isset($url_components['query'])){
            parse_str($url_components['query'], $params);
        }
    
        $path = explode('/', $url_components['path']);
        if(count($path) > 0) {
            $path = array_filter($path, function($item){
                return $item !== null && trim($item) != "";
            });
            $path = array_values($path);
    
            if(count($path) > 0) {
                $script_name = $path[count($path) - 1];
                if(strpos($script_name, '/') === 0) {
                    $script_name = substr($script_name, 1);
                }
            }
        }
    
        $post_edition = in_array($script_name, array('post-new.php', 'post.php'));
        if($post_edition) {
            $edited_post_type = isset($params['post_type']) ? $params['post_type'] : 'post';
        }
    
        if($post_edition && isset($params['post'])){
            $post = get_post($params['post']);
            $edited_post_type = get_post_type($post);
        }
        
        $comment_edition = in_array($script_name, array('comment.php'));
    
        $term_edition = in_array($script_name, array('term.php', 'edit-tags.php', 'edit-tag-form.php'));
        $edited_term_taxonomy = null;
        if(isset($params['taxonomy'])){
            $edited_term_taxonomy = $params['taxonomy'];
        }
    
        $url_slug = trim($_SERVER['REQUEST_URI']);
        if($url_slug != "" && get_option('permalink_structure') == '/%postname%/') {
            if($url_slug[0] == "/") {
                $url_slug = substr($url_slug, 1);
            }
            
            if(strlen($url_slug) >= 1 && $url_slug[strlen($url_slug) - 1] == '/') {
                $url_slug = substr($url_slug, 0, strlen($url_slug) - 1);
            }
    
            $query_args_pos = strpos($url_slug, '?');
            if($query_args_pos !== false) {
                $url_slug = substr($url_slug, 0, $query_args_pos);
            }
    
            if(strlen($url_slug) > 1 && $url_slug[strlen($url_slug) - 1] == '/') {
                $url_slug = substr($url_slug, 0, strlen($url_slug) - 1);
            }
        }
    
        $user_edition = in_array($script_name, array('profile.php', 'user-edit.php', 'user-new.php'));
        return array(
            'script_name' => $script_name,
            'params' => $params,
            'is_admin' => $is_admin,
            'post_edition' => $post_edition,
            'comment_edition' => $comment_edition,
            'edited_post_type' => $edited_post_type,
            'term_edition' => $term_edition,
            'edited_term_taxonomy' => $edited_term_taxonomy,
            'user_edition' => $user_edition,
            'url_slug' => $url_slug
        );
    }
}

if(!function_exists('tw_pdo_connection')){
    function tw_pdo_connection() {
        global $wpdb;
        $host_data = $wpdb->parse_db_host(DB_HOST);
	
        if (is_array($host_data)) {
            list($host, $port, $socket, $is_ipv6) = $host_data;
        } else {
            // Redacted. Throw an error or something 
        }

        // Wrap the IPv6 host in braces as required
        if ($is_ipv6 && extension_loaded('mysqlnd')) {
            $host = "[$host]";
        }

        // Generate either a socket connection string or TCP connection string
        if (isset($socket)) {
            $connection_str = 'mysql:unix_socket=' . $socket . ';dbname=' . DB_NAME . ';charset=' . DB_CHARSET;
        } else {
            $connection_str = 'mysql:host=' . $host . ';dbname=' . DB_NAME . ';charset=' . DB_CHARSET;

            if (isset($port)) {
                $connection_str .= ';port=' . $port;
            }
        }

        // Open the connection
        $pdo = new PDO($connection_str, DB_USER, DB_PASSWORD);
        return $pdo;
    }
}

if(!function_exists('tw_get_decimal_part')){
    function tw_get_decimal_part($number) {
        $decimalPart = 0;
        if(filter_var($number, FILTER_VALIDATE_FLOAT) === false) {
            return $decimalPart;
        }

        $number = filter_var($number, FILTER_VALIDATE_FLOAT);
        $numberStr = (string)$number;
        
        $decimalPointPos = strpos($numberStr, '.');
        if ($decimalPointPos !== false) {
            $decimalPart = substr($numberStr, $decimalPointPos + 1);
            $decimalPart = (int)$decimalPart;
        }
    
        return $decimalPart;
    }
}

if(!function_exists("tw_ensure_not_duplicated_hostname")){
    function tw_ensure_not_duplicated_hostname($url)
    {
        $toReplace = $_SERVER['SERVER_NAME'];

        $hostnamePos = strpos($url, $toReplace, 0);
        $beforeHostname = substr($url, 0, $hostnamePos);
        $afterHostname = substr($url, $hostnamePos);
        $afterHostname = str_replace($toReplace, '', $afterHostname);

        $newUrl = $beforeHostname . $toReplace . $afterHostname;
        $newUrl = preg_replace('#(?<!' . strtolower($_SERVER['REQUEST_SCHEME']) . ':)/{2,}#', '/', $newUrl);
        return $newUrl;
    }
}

if(!function_exists("tw_get_pagination_base_url")){
    function tw_get_pagination_base_url($baseUrl, $pageNumberToAppend = null)
    {
        if(isset($_SERVER["HTTP_REFERER"])){
            $refererUrl = tw_ensure_not_duplicated_hostname($_SERVER['HTTP_REFERER']);
            $refererParts = parse_url($refererUrl);
            $referer = $refererParts['scheme'] . '://' . $refererParts['host'] . $refererParts['path'];

            foreach($GLOBALS['current_url_expression_to_replace'] as $expression) {
                $referer = preg_replace($expression, '', $referer);
                $baseUrl = preg_replace($expression, '', $baseUrl);
            }

            $currentUrlSchemeAndUri = $_SERVER["REQUEST_SCHEME"] . '://' . $_SERVER["SERVER_NAME"] . '/wp-admin/admin-ajax.php'; 
            
            if(is_string($GLOBALS['url_expression_to_append'])){
                $desiredUrlSchemeAndUri = $referer . $GLOBALS['url_expression_to_append'] . $pageNumberToAppend;
            } else {
                $desiredUrlSchemeAndUri = $referer . $GLOBALS['url_expression_to_append']($pageNumberToAppend, $referer);
            }
            $baseUrl = str_replace($currentUrlSchemeAndUri, $desiredUrlSchemeAndUri, $baseUrl);
        }

        foreach($GLOBALS['current_url_parameters_to_remove'] as $paramName) {
            $baseUrl = remove_query_arg($paramName, $baseUrl);
        }

        $baseUrl = preg_replace('#(?<!' . strtolower($_SERVER['REQUEST_SCHEME']) . ':)/{2,}#', '/', $baseUrl);
        return $baseUrl;
    }
}

if(!function_exists("tw_override_paginate_link_output")){
    function tw_override_paginate_link_output($html, $args)
    {
        remove_filter('paginate_links_output', 'tw_override_paginate_link_output', PHP_INT_MAX);
        $args['base'] = tw_get_pagination_base_url($args['base']);
        if(isset($args['add_args']['page'])){
            unset($args['add_args']['page']);
        }

        $html = paginate_links($args);
        add_filter('paginate_links_output', 'tw_override_paginate_link_output', PHP_INT_MAX, 2);
        return $html;
    }
}

if(!function_exists('tw_override_pagenum_link')){
    function tw_override_pagenum_link($baseUrl, $pagenum){
        global $paged;
        if($pagenum != $paged) {
            $baseUrl = tw_get_pagination_base_url($baseUrl, $pagenum);
        } else {
            $baseUrl = tw_get_pagination_base_url($baseUrl);
        }
        return $baseUrl;
    }
}

if(!function_exists("tw_override_ajax_pagination")){
    /**
     * @param $urlExpressionToAppend string or function($pagenumber, $request_uri)
     */
    function tw_override_ajax_pagination($urlExpressionToAppend = '', $urlExpressionToReplace = [], $urlParametersToRemove = ['action']){        
        $GLOBALS['url_expression_to_append'] = $urlExpressionToAppend;
        $GLOBALS['current_url_expression_to_replace'] = $urlExpressionToReplace;
        $GLOBALS['current_url_parameters_to_remove'] = $urlParametersToRemove;
        
        add_filter('get_pagenum_link', 'tw_override_pagenum_link', PHP_INT_MAX, 2);
        add_filter('paginate_links_output', 'tw_override_paginate_link_output', PHP_INT_MAX, 2);
    }
}

if(!function_exists('tw_restore_ajax_pagination')){
    function tw_restore_ajax_pagination(){
        unset($GLOBALS['url_expression_to_append']);
        unset($GLOBALS['current_url_expression_to_replace']);
        unset($GLOBALS['current_url_parameters_to_remove']);

        remove_filter('get_pagenum_link', 'tw_override_pagenum_link');
        remove_filter('paginate_links_output', 'tw_override_paginate_link_output', PHP_INT_MAX);
    }
}

if(!function_exists('tw_format_json_string')) {
    function tw_format_json_string($stringContent){            
        $formattedString = addslashes($stringContent);
        $formattedString = str_replace('"', '\'', $formattedString);
        return $formattedString;
    }
}

if(!function_exists("tw_convert_line_breaks")){
    function tw_convert_line_breaks($stringContent){
        $stringContent = preg_replace('/\r\n/', '<br />', $stringContent);
        $stringContent = preg_replace('/\n/', '<br />', $stringContent);

        return $stringContent;
    }
}

if(!function_exists("tw_number_from_string")){
    function tw_number_from_string($stringContent){
        $number = 0;
        for($i=0; $i<strlen($stringContent); $i++) {
            $charCode = ord($stringContent[$i]);
            $number = $number + $charCode;
        }

        return $number;
    }
}

function tw_generate_random_hex() {
    return substr(bin2hex(random_bytes(4)), 0, 7);
}

function tw_render_template($templatePath, $vars = [])
{
    ob_start();
    load_template($templatePath, false, $vars);
    $tplContent = ob_get_contents();
    ob_end_clean();

    return $tplContent;
}
