<?php
/**
 * Plugin Name: TW Core
 * Description: Enable TW customisation
 * Version:     1.0.0
 * Author:      techniway
 * Text Domain: tw
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

require_once(__DIR__ . '/vendor/autoload.php');
require_once __DIR__ . '/utility.php';
require_once __DIR__ . '/wordpress_utility.php';
require_once __DIR__ . '/ecommerce_utility.php';
require_once __DIR__ . '/tw_core_enum.php';
require_once __DIR__ . '/theme_variables_loader.php';

require_once __DIR__ . '/classes/tw_stylesheet.php';
require_once __DIR__ . '/classes/tw_template_parser.php';
require_once __DIR__ . '/classes/tw_metabox.php';
require_once __DIR__ . '/classes/tw_rest_search_controller.php';
require_once __DIR__ . '/classes/tw_core_exception.php';
require_once __DIR__ . '/classes/tw_attributes_trait.php';
require_once __DIR__ . '/classes/tw_variation_trait.php';
require_once __DIR__ . '/classes/tw_supplier_trait.php';
require_once __DIR__ . '/classes/tw_delivery_trait.php';
require_once __DIR__ . '/classes/tw_stock_management_trait.php';
require_once __DIR__ . '/classes/tw_factory.php';

tw_include_files(__DIR__ . '/repository', 'include', function($classname){
	TW_Factory::getInstance()->instantiateClass($classname);
});
tw_include_files(__DIR__ . '/includes');
tw_include_files(__DIR__ . '/commands');

$GLOBALS['tw_registered_filters'] = [];
$GLOBALS['tw_registered_actions'] = [];
$GLOBALS['supported_products_type'] = [
	'simple' => [
		'initial_classname' => 'WC_Product_Simple',
		'classname' => 'TW_Product_Simple',
		'path'	=> __DIR__ . '/classes/tw_product_simple.php',
		'name' => 'Simple product'
	],
	'simple-with-variations' => [
		'initial_classname'	=> 'WC_Product_Simple_With_Variations',
		'classname' => 'TW_Product_Variable',
		'path'	=> __DIR__ . '/classes/tw_product_variable.php',
		'name' => 'Variable product',
	]
];

add_action('init', function(){
	tw_custom_page(
        '^tw-core/test',
        [],
        null,
        function() {
			echo 'cmoi';
			
            $product = wc_get_product(541);
			var_dump($product->get_stock_quantity());
			var_dump($product->get_manage_stock());

			$product->set_stock_quantity(32);
			$product->save();
			$toto = "lolo";
        }
    );
}, PHP_INT_MAX);

add_filter('product_type_selector', function($product_types){
	$supported_products = [
		'external'	=> __( 'External/Affiliate product', 'woocommerce' )
	];

	foreach($GLOBALS['supported_products_type'] as $product_key => $product_detail) {
		$supported_products[$product_key] = __($product_detail['name'], 'woocommerce');
	}

	return $supported_products;
}, PHP_INT_MAX);

add_action('elementor/dynamic_tags/register', function($dynamic_tag_manager){
	require_once( __DIR__ . '/custom_elementor_tags.php');
	tw_register_custom_elementor_tags_group($dynamic_tag_manager);
	tw_register_custom_elementor_tags($dynamic_tag_manager);
});

add_filter('woocommerce_checkout_redirect_empty_cart', function($shouldRedirect){
	return false;
}, PHP_INT_MAX);

add_filter('woocommerce_checkout_update_order_review_expired', function($shouldDisplayErrorMessage){
	if(WC()->cart->is_empty()) {
		$shouldDisplayErrorMessage = false;
	}
	return $shouldDisplayErrorMessage;
}, PHP_INT_MAX);

/*
add_filter('woocommerce_get_script_data', function($params, $handle){
	if($handle == 'wc-checkout') {
		$params['is_checkout'] = 0;
	}

	return $params;
}, PHP_INT_MAX, 2);
*/

add_filter('woocommerce_add_error', function($message){
	if(WC()->cart->is_empty() && is_checkout()){
		$message = __("Vous ne pouvez pas passer commander avec un panier vide !!!", "tw-core");
	}
	return $message;
});

add_filter('woocommerce_product_class', function($classname, $product_type, $product_variation_or_product, $product_id){
	$overriden_classnames = [];
	foreach($GLOBALS['supported_products_type'] as $product_key => $product_detail) {
		$overriden_classnames[$product_key] = $product_detail['initial_classname'];
	}

	if(in_array($classname, array_values($overriden_classnames))){
		$key = array_search($classname, $overriden_classnames);
		$overriden_class_info = $GLOBALS['supported_products_type'][$key];
		
		require_once $overriden_class_info['path'];
		return $overriden_class_info['classname'];
	}

	return $classname;
}, PHP_INT_MAX, 4);

/*
add_action('woocommerce_checkout_before_order_review', function(){
	$cart = WC()->cart;
	$toto = "lolo";
}, PHP_INT_MAX);
*/

//support de l'ajout au panier des class overloadées
add_action( 'woocommerce_simple-with-variations_add_to_cart', 'woocommerce_simple_add_to_cart', 30);

function tw_core_override_rest_controllers(){
	$rest_handlers_loaded = false;
	$rest_search_handlers = null;

	add_filter('wp_rest_search_handlers', function($handlers) use ($rest_search_handlers, $rest_handlers_loaded){
		$rest_search_handlers = $handlers;
		if($rest_handlers_loaded === false) {
			add_action('rest_api_init', function() use ($rest_search_handlers){
				$tw_rest_search_controller = new TW_Rest_Search_Controller($rest_search_handlers);

				register_rest_route(
					'wp/v2',
					'/search',
					array(
						array(
							'methods' => WP_REST_Server::READABLE,
							'callback' => array($tw_rest_search_controller, 'get_items_with_filter'),
							'permission_callback' => array($tw_rest_search_controller, 'get_items_permission_check'),
							'args' => $tw_rest_search_controller->get_collection_params(),
						),
						'schema' => array($tw_rest_search_controller, 'get_public_item_schema')
					),
					true
				);
			}, PHP_INT_MAX);
		}

		$rest_handlers_loaded = true;
		return $rest_search_handlers;
	});
}
add_action('init', 'tw_core_override_rest_controllers', 0);

function tw_plugin_enqueue_admin_styles() {
    $plugin_url = get_bloginfo('url') . '/wp-content/plugins/tw-core';
	wp_enqueue_editor();
	
	$isElementor = (isset($_GET['action']) && $_GET['action'] == 'elementor') ? true : false;
	if(!$isElementor) {
		wp_enqueue_media();
	}

	wp_enqueue_style('tw_field', $plugin_url. '/css/metabox_fields.css');
    wp_enqueue_script('tw_field', $plugin_url . '/js/metabox_fields.js', array('jquery', 'jquery-ui-datepicker'), false, true);
    wp_enqueue_style( 'tw_field', $plugin_url . '/css/jquery_ui/jquery_ui.css', array(), '1.11.4' );

	wp_enqueue_style('tw_admin_form', $plugin_url . '/css/admin_form.css');
}
add_action('admin_init', 'tw_plugin_enqueue_admin_styles', 10, 0);