<?php

class TW_Product_Repository {

    protected $_cache = [
        'customAttributes' => [],
        'customTaxonomy' => []
    ];

    public function loadCustomAttributes($product_id){
        global $wpdb;
        $customAttributes = [];
        $custom_attribute_keys = [];

        if(!is_array($product_id)){
            if(isset($this->_cache['customAttributes'][$product_id])){
                return $this->_cache['customAttributes'][$product_id];
            }

            if(isset($GLOBALS['tw_product_default_attributes']) && count($GLOBALS['tw_product_default_attributes']) > 0) {
                foreach(array_keys($GLOBALS['tw_product_default_attributes']) as $attr_key) {
                    $custom_attribute_keys['_productattribute_' . $attr_key] = $attr_key;
                }
    
                $query = 
                    "SELECT wpm.meta_key, wpm.meta_value  
                    FROM wp_postmeta wpm 
                    WHERE wpm.post_id = " . esc_sql($product_id)
                    . " AND wpm.meta_key in (" . tw_explode_strings(array_keys($custom_attribute_keys)) . ")";
    
                $res = $wpdb->get_results(
                    $query,
                    ARRAY_N
                );
                foreach($res as $attr) {
                    $customAttributes[$custom_attribute_keys[$attr[0]]] = $attr[1];
                }
            }
            $this->_cache['customAttributes'][$product_id] = $customAttributes;
        } else {
            $cacheResults = [];
            foreach($product_id as $id) {
                if(isset($this->_cache['customAttributes'][$id])){
                    $cacheResults[$id] = $this->_cache['customAttributes'][$id];
                }
            }

            $remainingKeys = array_diff($product_id, array_keys($cacheResults));
            if(count($remainingKeys) == 0) {
                return $cacheResults;
            }

            if(isset($GLOBALS['tw_product_default_attributes']) && count($GLOBALS['tw_product_default_attributes']) > 0) {
                foreach(array_keys($GLOBALS['tw_product_default_attributes']) as $attr_key) {
                    $custom_attribute_keys['_productattribute_' . $attr_key] = $attr_key;
                }
    
                $query = 
                    "SELECT wpm.post_id, wpm.meta_key, wpm.meta_value  
                    FROM wp_postmeta wpm 
                    WHERE wpm.post_id in (" . tw_explode_ids($product_id) . ")"
                    . " AND wpm.meta_key in (" . tw_explode_strings(array_keys($custom_attribute_keys)) . ")";
    
                $res = $wpdb->get_results(
                    $query,
                    ARRAY_A
                );

                foreach($res as $attr) {
                    if(!isset($customAttributes[$attr['post_id']])){
                        $customAttributes[$attr['post_id']] = [];
                    }

                    $customAttributes[$attr['post_id']][$custom_attribute_keys[$attr['meta_key']]] = $attr['meta_value'];
                }

                foreach($product_id as $id) {
                    $this->_cache['customAttributes'][$id] = $customAttributes[$id];
                }
            }
        }
        return $customAttributes;
    }

    public function getCustomAttributesList($outputMode = "FULL", $termTaxonomyIds = []){
        global $wpdb;
        $customAttributes = [];
        $custom_attribute_keys = [];

        if(isset($GLOBALS['tw_product_default_attributes']) && count($GLOBALS['tw_product_default_attributes']) > 0) {
            foreach(array_keys($GLOBALS['tw_product_default_attributes']) as $attr_key) {
                $custom_attribute_keys['_productattribute_' . $attr_key] = $attr_key;
            }
        }

        if(count($custom_attribute_keys) > 0) {

            if(count($termTaxonomyIds) < 1) {
                $query = "SELECT wpm.meta_key, wpm.meta_value  
                    FROM wp_postmeta wpm 
                    WHERE wpm.meta_key in (" . tw_explode_strings(array_keys($custom_attribute_keys)) . ")
                    GROUP BY wpm.meta_key, wpm.meta_value
                ";
            } else {
                $query = "SELECT wpm.meta_key, wpm.meta_value  
                    FROM wp_postmeta wpm 
                    INNER JOIN wp_posts product on (product.ID = wpm.post_id)
                    INNER JOIN wp_term_relationships product_rel on (product_rel.object_id = product.ID AND product_rel.term_taxonomy_id IN (" . tw_explode_ids($termTaxonomyIds) . "))
                    WHERE wpm.meta_key in (" . tw_explode_strings(array_keys($custom_attribute_keys)) . ")
                    GROUP BY wpm.meta_key, wpm.meta_value
                ";
            }

            $res = $wpdb->get_results($query, ARRAY_A);
            foreach($res as $item) {
                if(!isset($customAttributes[$item['meta_key']])){
                    $customAttributes[$item['meta_key']] = [];
                }

                if($outputMode == "FULL") {
                    $customAttributes[$item['meta_key']][] = $item;
                } else if($outputMode == "SLUG") {
                    $customAttributes[$item['meta_key']][] = $item['meta_value'];
                }
            }
        }

        return $customAttributes;
    }

    public function loadCustomTaxonomy($product_id){
        global $wpdb;
        $customTaxonomies = [];
        $custom_taxonomy_keys = [];

        if(!is_array($product_id)){
            if(isset($this->_cache['customTaxonomy'][$product_id])){
                return $this->_cache['customTaxonomy'][$product_id];
            }

            if(isset($GLOBALS['tw_product_default_taxonomy']) && count($GLOBALS['tw_product_default_taxonomy']) > 0) {
                foreach($GLOBALS['tw_product_default_taxonomy'] as $tax_key) {
                    $custom_taxonomy_keys['pa_' . $tax_key] = $tax_key;
                }
    
                $query = "SELECT wt.term_id, wt.name, wt.slug, wtt.taxonomy, wtt.description
                FROM wp_term_relationships wtr
                inner join wp_term_taxonomy wtt on (wtt.term_taxonomy_id = wtr.term_taxonomy_id)
                inner join wp_terms wt on (wt.term_id = wtt.term_id)
                where wtr.object_id = " . esc_sql($product_id) . "
                and wtt.taxonomy in (" . tw_explode_strings(array_keys($custom_taxonomy_keys)) . ")";

                $res = $wpdb->get_results(
                    $query,
                    ARRAY_A
                );
                foreach($res as $attr_value) {
                    $taxonomyName = $attr_value['taxonomy'];
                    if(!isset($customTaxonomies[$custom_taxonomy_keys[$taxonomyName]])){
                        $customTaxonomies[$custom_taxonomy_keys[$taxonomyName]] = [];
                    }
                    
                    $customTaxonomies[$custom_taxonomy_keys[$taxonomyName]][$attr_value['name']] = [
                        'slug' => $attr_value['slug'],
                        'taxonomy' => $taxonomyName,
                        'term_id' => $attr_value['term_id'],
                        'name' => $attr_value['name'],
                        'description' => $attr_value['description']
                    ];
                }
                $this->_cache['customTaxonomy'][$product_id] = $customTaxonomies;
            }
        } else {
            $cacheResults = [];
            foreach($product_id as $id) {
                if(isset($this->_cache['customTaxonomy'][$id])){
                    $cacheResults[$id] = $this->_cache['customTaxonomy'][$id];
                }
            }

            $remainingKeys = array_diff($product_id, array_keys($cacheResults));
            if(count($remainingKeys) == 0) {
                return $cacheResults;
            }

            if(isset($GLOBALS['tw_product_default_taxonomy']) && count($GLOBALS['tw_product_default_taxonomy']) > 0) {
                foreach($GLOBALS['tw_product_default_taxonomy'] as $tax_key) {
                    $custom_taxonomy_keys['pa_' . $tax_key] = $tax_key;
                }
    
                $query = "SELECT wtr.object_id, wt.term_id, wt.name, wt.slug, wtt.taxonomy, wtt.description
                FROM wp_term_relationships wtr
                inner join wp_term_taxonomy wtt on (wtt.term_taxonomy_id = wtr.term_taxonomy_id)
                inner join wp_terms wt on (wt.term_id = wtt.term_id)
                where wtr.object_id IN (" . tw_explode_ids($product_id) . ")
                and wtt.taxonomy in (" . tw_explode_strings(array_keys($custom_taxonomy_keys)) . ")";
    
                $res = $wpdb->get_results(
                    $query,
                    ARRAY_A
                );
                foreach($res as $attr_value) {
                    if(!isset($customTaxonomies[$attr_value['object_id']])){
                        $customTaxonomies[$attr_value['object_id']] = [];
                    }

                    $taxonomyName = $attr_value['taxonomy'];
                    if(!isset($customTaxonomies[$attr_value['object_id']][$custom_taxonomy_keys[$taxonomyName]])){
                        $customTaxonomies[$attr_value['object_id']][$custom_taxonomy_keys[$taxonomyName]] = [];
                    }
                    
                    $customTaxonomies[$attr_value['object_id']][$custom_taxonomy_keys[$taxonomyName]][$attr_value['name']] = [
                        'slug' => $attr_value['slug'],
                        'taxonomy' => $taxonomyName,
                        'term_id' => $attr_value['term_id'],
                        'name' => $attr_value['name'],
                        'description' => $attr_value['description']
                    ];
                }

                foreach($product_id as $id) {
                    $this->_cache['customTaxonomy'][$id] = $customTaxonomies[$id];
                }
            }
        }

        return $customTaxonomies;
    }

    public function getCustomTaxonomyList($outputMode = "FULL", $termTaxonomyIds = [])
    {
        global $wpdb;
        $customTaxonomies = [];
        $custom_taxonomy_keys = [];

        if(isset($GLOBALS['tw_product_default_taxonomy']) && count($GLOBALS['tw_product_default_taxonomy']) > 0) {
            foreach($GLOBALS['tw_product_default_taxonomy'] as $tax_key) {
                $custom_taxonomy_keys['pa_' . $tax_key] = $tax_key;
            }
        }

        if(count($custom_taxonomy_keys) > 0) {
            if(count($termTaxonomyIds) > 0) {
                $query = "SELECT wt.term_id, wt.name, wt.slug, wtt.taxonomy, wtt.description
                    FROM wp_term_relationships wtr
                    inner join wp_term_taxonomy wtt on (wtt.term_taxonomy_id = wtr.term_taxonomy_id)
                    inner join wp_terms wt on (wt.term_id = wtt.term_id)";

                $query .= "
                    INNER JOIN wp_posts product on (product.ID = wtr.object_id)
                    INNER JOIN wp_term_relationships product_rel on (product_rel.object_id = product.ID AND product_rel.term_taxonomy_id IN (" . tw_explode_ids($termTaxonomyIds) . "))";

                $query .= " left join wp_termmeta wtm on (wtm.term_id = wtt.term_id)
                    where wtt.taxonomy in (" . tw_explode_strings(array_keys($custom_taxonomy_keys)) . ")
                    GROUP BY wt.term_id
                    ORDER BY wtm.meta_value";
            } else {
                $query = "SELECT wt.term_id, wt.name, wt.slug, wtt.taxonomy, wtt.description
                    FROM wp_term_relationships wtr
                    inner join wp_term_taxonomy wtt on (wtt.term_taxonomy_id = wtr.term_taxonomy_id)
                    inner join wp_terms wt on (wt.term_id = wtt.term_id)
                    left join wp_termmeta wtm on (wtm.term_id = wtt.term_id)

                    where wtt.taxonomy in (" . tw_explode_strings(array_keys($custom_taxonomy_keys)) . ")
                    GROUP BY wt.term_id
                    ORDER BY wtm.meta_value";
            }

            $res = $wpdb->get_results($query, ARRAY_A);
            foreach($res as $item) {
                if(!isset($customTaxonomies[$item['taxonomy']])){
                    $customTaxonomies[$item['taxonomy']] = [];
                }

                if ($outputMode == "FULL") {
                    $customTaxonomies[$item['taxonomy']][$item['slug']] = $item;
                } else if($outputMode == "SLUG"){
                    $customTaxonomies[$item['taxonomy']][$item['slug']] = $item['name'];
                }
            }
        }

        return $customTaxonomies;
    }

    public function linkedProductIds($product_id){
        global $wpdb;
        $linkedProductIds = [];

        $query = "SELECT tvp.target_product_id
            FROM tw_variable_product tvp
            where tvp.product_id  = " . esc_sql($product_id);


        $linkedProductIds = $wpdb->get_col(
            $query
        );
        $linkedProductIds[] = $product_id;
        return $linkedProductIds;
    }

    public function slugMatchedProductIds($taxonomyName, $slugValues, $productIdsToLimit = []){
        global $wpdb;
        $productIds = [];

        $query = "SELECT distinct(wtr.object_id)
        FROM wp_term_relationships wtr
        inner join wp_term_taxonomy wtt on (wtt.term_taxonomy_id = wtr.term_taxonomy_id)
        inner join wp_terms wt on (wt.term_id = wtt.term_id)";

        $query .= " WHERE wtt.taxonomy = '" . esc_sql($taxonomyName) . "'";
        $query .= " AND wt.slug in (" . tw_explode_strings($slugValues) . ")";

        if(count($productIdsToLimit) > 0) {
            $query .= " AND wtr.object_id IN (" . tw_explode_ids($productIdsToLimit) . ")";
        }

        $productIds = $wpdb->get_col(
            $query
        );
        return $productIds;
    }

    /**
     * retourne l'ensemble des catégories de produit qui sont l'enfant de la catégorie désignée
     * ne gère pas 3 niveau de récurisité gère juste la relation parent, enfant
     */
    public function getCategoriesIdsWithChild($ids, $taxonomy = 'product_cat'){
        global $wpdb;
        $categories = [];
        $nbrChilds = 0;

        if(!is_array($ids)){
            $ids = [$ids];
        }

        $query = "SELECT wtt.parent, wtt.term_taxonomy_id, wtt.taxonomy,
            wt.term_id, wt.name, wt.slug, wt.term_group
            FROM wp_term_taxonomy wtt 
            INNER JOIN wp_terms wt on (wt.term_id = wtt.term_id)
            WHERE wtt.taxonomy = '" . esc_sql($taxonomy) . "'";
        
        $results = $wpdb->get_results($query, ARRAY_A);
        foreach($results as $item) {
            foreach($ids as $id) {
                if($item['term_id'] == $id) {
                    $wpTermArgs = new stdClass();
                    $wpTermArgs->term_id = $item['term_id'];
                    $wpTermArgs->name = $item['name'];
                    $wpTermArgs->slug = $item['slug'];
                    $wpTermArgs->term_group = $item['term_group'];
                    $wpTermArgs->term_taxonomy_id = $item['term_taxonomy_id'];
                    $wpTermArgs->taxonomy = $taxonomy;
                    $wpTermArgs->parent = 0;

                    $currentCategoryTerm = new WP_Term($wpTermArgs);
                    $item['link'] = get_term_link($currentCategoryTerm);
                    $categories[$item['slug']] = $item;
                }
            }
        }

        foreach($results as $item) {
            if(!in_array($item['term_id'], $ids)) {
                if(in_array($item['parent'], $ids)) {
                    $wpTermArgs = new stdClass();
                    $wpTermArgs->term_id = $item['term_id'];
                    $wpTermArgs->name = $item['name'];
                    $wpTermArgs->slug = $item['slug'];
                    $wpTermArgs->term_group = $item['term_group'];
                    $wpTermArgs->term_taxonomy_id = $item['term_taxonomy_id'];
                    $wpTermArgs->taxonomy = $taxonomy;
                    $wpTermArgs->parent = 0;

                    $currentCategoryTerm = new WP_Term($wpTermArgs);
                    $item['link'] = get_term_link($currentCategoryTerm);
                    $categories[$item['slug']] = $item;
                }
            }
        }

        return $categories;
    }
    
    /**
     * ne gère pas 3 niveau de récurisité gère juste la relation parent, enfant
     */
    public function getCategoriesSlugWithChild($slugs, $taxonomy = 'product_cat'){
        global $wpdb;
        $categories = [];
        $nbrChilds = 0;

        $seenIds = [];
        if(!is_array($slugs)){
            $slugs = [$slugs];
        }

        $query = "SELECT wtt.parent, wtt.term_taxonomy_id, wtt.taxonomy,
            wt.term_id, wt.name, wt.slug, wt.term_group
            FROM wp_term_taxonomy wtt 
            INNER JOIN wp_terms wt on (wt.term_id = wtt.term_id)
            WHERE wtt.taxonomy = '" . esc_sql($taxonomy) . "'";
        
        $results = $wpdb->get_results($query, ARRAY_A);
        foreach($results as $item) {
            foreach($slugs as $slug) {
                if($item['slug'] == $slug) {
                    $wpTermArgs = new stdClass();
                    $wpTermArgs->term_id = $item['term_id'];
                    $wpTermArgs->name = $item['name'];
                    $wpTermArgs->slug = $item['slug'];
                    $wpTermArgs->term_group = $item['term_group'];
                    $wpTermArgs->term_taxonomy_id = $item['term_taxonomy_id'];
                    $wpTermArgs->taxonomy = $taxonomy;
                    $wpTermArgs->parent = 0;

                    $currentCategoryTerm = new WP_Term($wpTermArgs);
                    $item['link'] = get_term_link($currentCategoryTerm);
                    $categories[$item['slug']] = $item;
                    $seenIds[] = $item['term_id'];
                }
            }
        }

        foreach($results as $item) {
            if(!in_array($item['slug'], $slugs)) {
                if(in_array($item['parent'], $seenIds)) {
                    $wpTermArgs = new stdClass();
                    $wpTermArgs->term_id = $item['term_id'];
                    $wpTermArgs->name = $item['name'];
                    $wpTermArgs->slug = $item['slug'];
                    $wpTermArgs->term_group = $item['term_group'];
                    $wpTermArgs->term_taxonomy_id = $item['term_taxonomy_id'];
                    $wpTermArgs->taxonomy = $taxonomy;
                    $wpTermArgs->parent = 0;

                    $currentCategoryTerm = new WP_Term($wpTermArgs);
                    $item['link'] = get_term_link($currentCategoryTerm);
                    $categories[$item['slug']] = $item;
                    $seenIds[] = $item['term_id'];
                }
            }
        }

        return $categories;
    }

    public function getProductCategories($categoriesSlugToExclude = [], $includeEmptyCategories = true)
    {
        global $wpdb;
        $stmt = "SELECT wtt.parent, wtt.term_taxonomy_id, wtt.taxonomy, wt.term_id, wt.name, wt.slug, wt.term_group,
            (
                SELECT count(DISTINCT object_id)
                FROM wp_term_relationships wtr 
                WHERE wtr.term_taxonomy_id = wt.term_id
            ) as 'nbr_products'
            FROM wp_term_taxonomy wtt 
            INNER JOIN wp_terms wt on (wt.term_id = wtt.term_id)
            WHERE wtt.taxonomy = 'product_cat'
        ";

        if(!empty($categoriesSlugToExclude)){
            $stmt .= " AND wt.slug NOT IN (" . tw_explode_strings($categoriesSlugToExclude) . ")";
        }        

        if(!$includeEmptyCategories) {
            $stmt .=" GROUP BY wtt.term_id
            HAVING nbr_products > 0";
        }

        return $wpdb->get_results($stmt, ARRAY_A);
    }
}