<?php

class TW_General_Repository {

    private $_cache = [
        'customPostTypeRecords' => []
    ];


    public function getDistinctMetaValues($key, $like = null){
        global $wpdb;
        $metaValues = [];

        $query = "SELECT DISTINCT(wpm.meta_value)  
        FROM wp_postmeta wpm 
        WHERE wpm.meta_key = '" . esc_sql($key) . "'";
        if($like !== null) {
            $query .= " AND wpm.meta_value LIKE '%" . esc_sql($like) . "%'";
        }

        $res = $wpdb->get_col(
            $query
        );
        return $res;
    }

    public function getAttachments($attachmentIds){
        global $wpdb;
        if(!is_array($attachmentIds)) {
            $attachmentIds = [$attachmentIds];
        }

        return $wpdb->get_results(
            "
                SELECT wp.ID, wp.post_title, wp.guid, wp.post_mime_type
                FROM wp_posts wp
                WHERE wp.ID IN (" . tw_explode_ids($attachmentIds) . ")
            ",
            ARRAY_A
        );
    }

    public function getCustomPostTypeRecord($postTypeKey, $slug) {
        global $wpdb;

        $metaSettings = [];
        $taxonomiesSettings = [];
        $recordValues = [];

        if(isset($this->_cache['customPostTypeRecords'][$postTypeKey . '_' . $slug])) {
            return $this->_cache['customPostTypeRecords'][$postTypeKey . '_' . $slug];
        }

        if(isset($GLOBALS['tw_metas']['post___' . $postTypeKey]) && !empty($GLOBALS['tw_metas']['post___' . $postTypeKey])) {
            $metaSettings = $GLOBALS['tw_metas']['post___' . $postTypeKey];
        }

        if(isset($GLOBALS['tw_taxonomies']['post___' . $postTypeKey]) && !empty($GLOBALS['tw_taxonomies']['post___' . $postTypeKey])) {
            $taxonomiesSettings = $GLOBALS['tw_taxonomies']['post___' . $postTypeKey];
        }

        $metaValues = [];
        $metaKeys = array_keys($metaSettings);
        if(count($metaKeys) > 0) {
            $metaValues = $wpdb->get_results(
                $wpdb->prepare("
                    SELECT wpm.meta_key, wpm.meta_value 
                    FROM wp_postmeta wpm 
                    INNER JOIN wp_posts wp on (wpm.post_id = wp.ID)
                    WHERE wp.post_type = %s
                    and wp.post_name = %s
                    and wp.post_status = %s
                    and wpm.meta_key in(" . tw_explode_strings($metaKeys) . ")
                ",
                [$postTypeKey, $slug, 'publish']
                ),
                ARRAY_A
            );
        } 

        foreach($metaValues as $item) {
            $key = $item['meta_key'];
            $value = $item['meta_value'];
            $type = $GLOBALS['tw_metas']['post___' . $postTypeKey][$key]['metabox_field']['field_type'];
            $multiple = false;
            if(isset($GLOBALS['tw_metas']['post___' . $postTypeKey][$key]['multiple']) && $GLOBALS['tw_metas']['post__' . $postTypeKey][$key]['multiple'] == true) {
                $multiple = true;
            }

            if(in_array($type, ['image', 'pdf'])) {
                if($multiple == true) {
                    $values = explode(',', $value);

                    if(!empty($values)) {
                        $recordValues[$key] = $this->getAttachments($values);
                    } else {
                        $recordValues[$key] = null;
                    }
                } else {
                    if(!empty($value)) {
                        $recordValues[$key] = $this->getAttachments($value);
                    } else {
                        $recordValues[$key] = null;
                    }
                }
            } else if($type == 'date') {
                $recordValues[$key] = DateTime::createFromFormat('Y-m-d', $value);
            } else {
                if($multiple == true) {
                    $values = explode(',', $value);
                    $recordValues[$key] = $values;
                } else {
                    $recordValues[$key] = $value;
                }
            }
        }

        $taxKeys = array_keys($taxonomiesSettings);
        $taxValues = $wpdb->get_results(
            $wpdb->prepare("
                SELECT wtt.taxonomy,  wpt.name, wpt.slug, wpt.term_id 
                FROM wp_term_relationships wtr 
                INNER JOIN wp_posts wp on (wtr.object_id = wp.ID)
                INNER JOIN wp_term_taxonomy wtt on (wtt.term_taxonomy_id = wtr.term_taxonomy_id)
                INNER JOIN wp_terms wpt on (wpt.term_id = wtt.term_id)
                WHERE wp.post_type = %s
                and wp.post_name = %s
            ",
            [$postTypeKey, $slug]
            ),
            ARRAY_A
        );
        foreach($taxValues as $item) {
            $key = $item['taxonomy'];
            $value = $item['name'];

            if(!isset($recordValues[$key])){
                $recordValues[$key] = [];
            }
            $recordValues[$key][] = $value;
        }
        
        $this->_cache['customPostTypeRecords'][$postTypeKey . '_' . $slug] = $recordValues;
        return $recordValues;
    }

    public function getPostWithCustomRecord($postId) {
        $post = get_post($postId);
        if($post !== null) {
            $postType = $post->post_type;
            $postSlug = $post->post_name;

            $customRecords = $this->getCustomPostTypeRecord($postType, $postSlug);
            $post->custom_records = $customRecords;
        }

        return $post;
    }
}

