(function($) {
    $(document).ready(function(){
        //init taxonomy fields
        if(typeof(window.tagBox) != "undefined") {
            window.tagBox.init();
        }

        $('.tw_date').each(function(){
            let $container = $(this).closest('.tw-meta-column');
            const existingDate = $container.find('.tw_date_hidden_input').val();
            
    
            const defaultSettings = $.datepicker._defaults;
            const regionalSettings = {
                'closeText': defaultSettings.closeText,
                'currentText': defaultSettings.currentText,
                'monthNames': defaultSettings.monthNames,
                'monthNamesShort': defaultSettings.monthNamesShort,
                'nextText': defaultSettings.nextText,
                'prevText': defaultSettings.prevText,
                'dayNames': defaultSettings.dayNames,
                'dayNamesShort': defaultSettings.dayNamesShort,
                'dayNamesMin': defaultSettings.dayNamesMin,
                'dateFormat': defaultSettings.dateFormat,
                'firstDay': defaultSettings.firstDay,
                'isRTL': defaultSettings.isRTL
            }
            const parsedDate = new Date(Date.parse(existingDate));
            if(!isNaN(parsedDate)){
                $(this).val($.datepicker.formatDate(regionalSettings.dateFormat, parsedDate, regionalSettings));
            }
                
            $(this).datepicker({
                altField: ".tw_date_hidden_input",
                altFormat: "yy-mm-dd",
            })
        });

        if (typeof(jQuery.ui.sortable) != 'undefined') {
            $('.tw-gallery-multiple').sortable({
                items: 'li',
                cursor: '-webkit-grabbing', // mouse cursor
                scrollSensitivity: 40,
                stop: function( event, ui ){
                    ui.item.removeAttr( 'style' );
    
                    let sort = new Array() // array of image IDs
                    const $gallery = $(this) // .misha-gallery
                    const $hiddenField = $gallery.closest('.tw-meta-content').find('input[type="hidden"]')
    
                    // each time after dragging we resort our array
                    $gallery.find( 'li' ).each( function( index ){
                        sort.push( $(this).attr( 'data-id' ) );
                    });
                    $hiddenField.val( sort.join() );
                }
            })
        }

         //textarea
         $('.tw_wysiwyg').each(function(){
            const id = $(this).attr('id');
            wp.editor.initialize(id);
         });

        //simple gallery
        $( '.tw-gallery-add' ).click( function( event ){
            event.preventDefault();
            
            const $button = $(this);
            const $hiddenField = $button.prev();
            const $gallery = $button.closest('.tw-meta-content').find('.tw-gallery');
            const dataType = $gallery.attr('data-type');

            let textButton = "Ajouter une image";
            if(dataType != "image") {
                textButton = "Ajouter un document";
            }
        
            const customUploader = wp.media({
                title: textButton,
                library: {
                    type: dataType
                },
                button: {
                    text: textButton
                },
                multiple: false
            }).on( 'select', function() {
                $gallery.find('.tw-gallery-remove').click();
                $hiddenField.val('');

                let selection = customUploader.state().get('selection');
                if(selection.length == 1){
                    const uploadedElement = selection.first().attributes;
                    console.log(uploadedElement);

                    $hiddenField.val(uploadedElement.id);

                    let galleryElement = "";
                    if(dataType == "image") {
                        galleryElement = '<li data-preview-type="image" data-id="' + uploadedElement.id + '">';
                        galleryElement += '<span class="preview" style="background-image:url(\'' + uploadedElement.url + '\');"></span>';
                        galleryElement += '<a href="#" class="tw-gallery-remove">&times;</a>';
                        galleryElement += '</li>';
                    } else {
                        galleryElement = '<li data-preview-type="document" data-id="' + uploadedElement.id + '">';
                        galleryElement += '<span data-preview-type="document" class="preview"></span>';
                        galleryElement += '<a href="#" class="tw-gallery-remove">&times;</a>';
                        galleryElement += '<span class="documentName">' + uploadedElement.name  + '</span>';
                        galleryElement += '</li>';
                    }

                    $gallery.append(galleryElement);
                }   
            }).open();
        });

        $(document).on('click', '.tw-gallery-remove', function(e){
            e.preventDefault();
            e.stopPropagation();

            const $link = $(this);
            const $gallery = $link.closest('.tw-gallery');
            const $hiddenField = $gallery.closest('.tw-meta-content').find('input[type="hidden"]');

            $hiddenField.val('');
            $gallery.html("");

            return false;
        });

        //multiple gallery
        $( '.tw-gallery-multiple-add' ).click( function( event ){
            event.preventDefault();
            
            const $button = $(this);
            const $hiddenField = $button.prev();
            const $gallery = $button.closest('.tw-meta-content').find('.tw-gallery-multiple');
            const dataType = $gallery.attr('data-type');

            let hiddenFieldValue = [];
            if($hiddenField.val().trim() != "") {
                hiddenFieldValue = $hiddenField.val().split(',');
            }
        
            let textButton = "Ajouter des images";
            if(dataType != "image") {
                textButton = "Ajouter des documents";
            }

            const customUploader = wp.media({
                title: textButton,
                library: {
                    type: dataType
                },
                button: {
                    text: textButton
                },
                multiple: true
            }).on( 'select', function() {
                let selectedElements = customUploader.state().get( 'selection' ).map( item => {
                    item.toJSON();
                    return item;
                });

                if(dataType == "image") {
                    selectedElements.map(element => {
                        let galleryElement = '<li data-preview-type="image" data-id="' + element.id + '">';
                        galleryElement += '<span class="preview" style="background-image:url(' + element.attributes.url + ')"></span>';
                        galleryElement += '<a href="#" class="tw-gallery-multiple-remove">×</a>';
                        galleryElement += '</li>';
                    
                        $gallery.append(galleryElement);
                        hiddenFieldValue.push(element.id);
                    });
                } else {
                    selectedElements.map(element => {
                        console.log(element);

                        let galleryElement = '<li data-preview-type="document" data-id="' + element.id + '">';
                        galleryElement += '<span data-preview-type="document" class="preview"></span>';
                        galleryElement += '<a href="#" class="tw-gallery-multiple-remove">×</a>';
                        galleryElement += '<span class="documentName">' + element.attributes.name  + '</span>';
                        galleryElement += '</li>';
                    
                        $gallery.append(galleryElement);
                        hiddenFieldValue.push(element.id);
                    });
                }

                $hiddenField.val(hiddenFieldValue.join());
                $gallery.sortable( 'refresh' );
            }).open();
        });

        $(document).on('click', '.tw-gallery-multiple-remove', function(e){
            e.preventDefault();
            e.stopPropagation();

            const $link = $(this);
            const imageId = $link.parent().data('id').toString();
            const $gallery = $link.closest('.tw-gallery-multiple');
            const $hiddenField = $gallery.closest('.tw-meta-content').find('input[type="hidden"]');

            let hiddenFieldValue = [];
            if($hiddenField.val().trim() != "") {
                hiddenFieldValue = $hiddenField.val().split(",");
            }
            const i = hiddenFieldValue.indexOf(imageId)

            $link.parent().remove();
            if( i != -1 ) {
                hiddenFieldValue.splice(i, 1);
            }
            $hiddenField.val(hiddenFieldValue.join());

            $gallery.sortable( 'refresh' );
            return false;
        });
    });
})(jQuery);