<?php
function tw_shipping_type_fields($fields){
    $newFields = [];
    $newFields['shipping_type'] = [
        'name' => 'shipping_type',
        'id' => 'shipping_type',
        'title'       => __( 'Type d\'expédition', 'tw_core'),
        'type'      => 'select',
        'class'     => 'wc-enhanced-select',
        'options' => [
            'outsourced_shipping_and_delivery' => __('Expédition et livraison externalisé', 'tw_core'),
            'manual_shipping_and_outsourced_delivery' => __('Expédition manuelle et livraison externalisé', 'tw_core'),
            'manual_shipping_and_manual_delivery' => __('Expédition manuelle et livraison manuelle', 'tw_core')
        ],
    ];
    $newFields['shipping_description'] = [
        'name' => 'shipping_description',
        'id' => 'shipping_description',
        'title'       => __( 'Description expéditeur', 'tw_core'),
        'type'      => 'textarea',
    ];

    foreach($fields as $k => $v) {
        $newFields[$k] = $v;
    }

    return $newFields;
}

add_filter('woocommerce_shipping_instance_form_fields_flat_rate', function($fields){
    return tw_shipping_type_fields($fields);
});
add_filter('woocommerce_shipping_instance_form_fields_free_shipping', function($fields){
    return tw_shipping_type_fields($fields);
});


function tw_save_shipping_type($shipping_methode_id, $settings){
    $option_name = 'shipping_type_' . $shipping_methode_id;
    delete_option($option_name);
    update_option($option_name, $settings['shipping_type']);


    $option_name = 'shipping_description' . $shipping_methode_id;
    delete_option($option_name);
    if($settings['shipping_description'] !== null && trim($settings['shipping_description']) != ''){
        update_option($option_name, $settings['shipping_description']);
    }
}
add_filter('woocommerce_shipping_flat_rate_instance_settings_values', function($settings, WC_Shipping_Method $shippingMethod){
    tw_save_shipping_type($shippingMethod->instance_id, $settings);
    return $settings;
}, PHP_INT_MAX, 2);
add_filter('woocommerce_shipping_free_shipping_instance_settings_values', function($settings, WC_Shipping_Method $shippingMethod){
    tw_save_shipping_type($shippingMethod->instance_id, $settings);
    return $settings;
}, PHP_INT_MAX, 2);