<?php

add_action('woocommerce_product_options_sku', function(){
    global $product_object;
    include dirname(__DIR__)  . '/templates/inventory_tab_fields.php';
}, PHP_INT_MAX, 0);

add_action('woocommerce_admin_process_product_object', function(WC_Product $product){
    if($product instanceof TW_Product_Simple || $product instanceof TW_Product_Variable) {
        $stock_management_data = null;
        if(isset($_POST['stock_management_mode'])){
            $stock_management_data = [
                'stock_management_mode' => $_POST['stock_management_mode'],
                'stock_management_url' => $_POST['stock_management_url']
            ];
        }
        $product->set_stock_management_data($stock_management_data);
    }
});

add_action('woocommerce_after_product_object_save', function(WC_Product $product, $product_store){
    if($product instanceof TW_Product_Simple || $product instanceof TW_Product_Variable) {
        $product->save_stock_management_data();
    }
}, PHP_INT_MAX, 2);

add_action('admin_init', function(){
    $js_url = plugin_dir_url(__DIR__) . 'js/admin_stock_management_form.js';
    wp_enqueue_script('tw_core_js_admin_stock_management_form', $js_url, array('jquery'), false, false);
}, 10, 0);