<?php

//TODO PROBLEME REINSERTION DU MEME PRODUIT
function tw_product_import_support_custom_mapping($mappings){
     //colonne rajoutée par les extensions
     $mappings['Supplier price'] = 'supplier_price';
     $mappings['Variable Product SKU'] = 'variable_product_sku';
     $mappings['Supplier'] = 'supplier_name';
     $mappings['Restocking delay'] = 'restocking_delay';
     $mappings['Manage restocking'] = 'manage_restocking';
     $mappings['Stock Management'] = 'stock_management';
     $mappings['Delivery Method'] = 'delivery_method';
 
     //ajout des taxonomies spécifiques
     if(isset($GLOBALS['tw_product_default_taxonomy'])){
         foreach($GLOBALS['tw_product_default_taxonomy'] as $taxonomyName) {
             $mappings[ucfirst(strtolower($taxonomyName))] = 'taxonomy_' . strtolower($taxonomyName);
         }
     }
 
     //ajout des attributs spécifiques
     if(isset($GLOBALS['tw_product_default_attributes'])){
         foreach($GLOBALS['tw_product_default_attributes'] as $attr_key => $attr_info) {
             $mappings[ucfirst(strtolower($attr_key))] = 'attributes_' . strtolower($attr_key);
         }
     }
 
     return $mappings;
}

add_filter('woocommerce_csv_product_import_mapping_default_columns', function($mappings){
    return tw_product_import_support_custom_mapping($mappings);
}, PHP_INT_MAX);


//prise en compte des données parsées
add_filter('woocommerce_product_importer_formatting_callbacks', function($callbacks, WC_Product_CSV_Importer $importer){

    $mapped_keys = $importer->get_mapped_keys();
    foreach($mapped_keys as $index => $heading) {
        if(in_array($heading, ['supplier_price', 'restocking_delay'])){
            $callbacks[$index] = array($importer, 'parse_int_field');
        } else if(in_array($heading, ['stock_management', 'delivery_method'])){
            if($heading == 'stock_management') {
                $callbacks[$index] = array($importer, 'parse_stock_management_field');
            } else if($heading == 'delivery_method') {
                $callbacks[$index] = array($importer, 'parse_delivery_method_field');
            }
        } else if($heading == 'manage_restocking') {
            $callbacks[$index] = array($importer, 'parse_bool_field');
        }
    }

    //quand on ajoute les mappings prendre en compte $this->get_mapeed_keys()
    return $callbacks;
}, PHP_INT_MAX, 2);

add_filter('tw_importer_expand_data', function($data, TW_Product_Csv_Importer $importer){
    if(!is_array($data['raw_attributes'])){
        $data['raw_attributes'] = [];
    }
    if(!is_array($data['meta_data'])){
        $data['meta_data'] = [];
    }

    if(isset($GLOBALS['tw_product_default_taxonomy'])){
        foreach($GLOBALS['tw_product_default_taxonomy'] as $taxonomyName) {
            $colName = 'taxonomy_' . strtolower($taxonomyName);
            if(defined_and_not_blank($data[$colName])){
                $parsedTaxInfo = $importer->parse_taxonomy($taxonomyName, $data[$colName]);
                $attribute = [
                    'name' => $taxonomyName,
                    'value' => $parsedTaxInfo,
                    'taxonomy' => 1
                ];
                $data['raw_attributes'][] = $attribute;
            }
            if(isset($data[$colName])){
                unset($data[$colName]);
            }
        }
    }

    if(isset($GLOBALS['tw_product_default_attributes'])){
        foreach($GLOBALS['tw_product_default_attributes'] as $attr_key => $attr_info) {
            $colName = 'attributes_' . strtolower($attr_key);
            if(defined_and_not_blank($data[$colName])){
                $attribute = [
                    'name' => strtolower($attr_key),
                    'value' => [$data[$colName]],
                    'taxonomy' => 0
                ];
                $data['raw_attributes'][] = $attribute;
                /*
                $meta = [
                    'key' => strtolower($attr_key),
                    'value' => $data[$colName]
                ];
                $data['meta_data'][] = $meta;
                */
            }
            if(isset($data[$colName])){
                unset($data[$colName]);
            }
        }
    }

    return $data;
}, PHP_INT_MAX, 2);

add_filter('tw_product_importer_before_import', function($parsed_data, TW_Product_Csv_Importer $importer){
    foreach($parsed_data as $parsed_data_row_key => &$parsed_data_row){
        if(isset($parsed_data_row['variable_product_sku'])){
            $parsed_cell = $importer->parse_variable_product_sku($parsed_data_row['variable_product_sku']);
            $parsed_data_row['variable_product_sku'] = $parsed_cell;
        }
    }

    return $parsed_data;
}, PHP_INT_MAX, 2);


add_action('woocommerce_product_import_inserted_product_object', function(WC_Product $product, $data){
    $tmp_upload_url = ABSPATH . 'tmp_uploads';
   
    if(isset($data['raw_gallery_image_ids']) && is_array($data['raw_gallery_image_ids']) && count($data['raw_gallery_image_ids']) > 0){
        $attachment_ids = [];
        foreach($data['raw_gallery_image_ids'] as $image) {
            if(strpos($image, '://') === false && strpos($image, 'tmp_uploads/') !== false) {
                try {
                    $fileName = basename($image);
                    $existing_attachment_args = [
                        'post_type'   => 'attachment',
                        'post_status' => 'any',
                        'fields'      => 'ids',
                        'meta_query'  => array( // @codingStandardsIgnoreLine.
                            'relation' => 'OR',
                            array(
                                'key'     => '_wp_attached_file',
                                'value'   => '^' . $fileName,
                                'compare' => 'REGEXP',
                            ),
                            array(
                                'key'     => '_wp_attached_file',
                                'value'   => '/' . $fileName,
                                'compare' => 'LIKE',
                            ),
                            array(
                                'key'     => '_wc_attachment_source',
                                'value'   => '/' . $fileName,
                                'compare' => 'LIKE',
                            ),
                        ),
                    ];
                    $existing_attachments = get_posts($existing_attachment_args);

                    if(count($existing_attachments) > 0) {
                        continue;
                    }

                    if(!file_exists($image)){
                        throw new TW_Core_Exception("IMAGE_NOT_FOUND");
                    }

                    $file_array = array();
                    $file_array['name'] = $fileName;
                    $file_array['tmp_name'] = $tmp_upload_url . '/' . $fileName;

                    $file = wp_handle_sideload(
                        $file_array,
                        array(
                            'test_form' => false,
                            'mimes' =>  wc_rest_allowed_image_mime_types(),
                        ),
                        current_time('Y/m')
                    );
                    if(isset($file['error'])){
                        throw new TW_Core_Exception("IMAGE_UPLOAD_ERROR");
                    }

                    $attachment_id = wc_rest_set_uploaded_image_as_attachment($file, $product->get_id());
                    if ( ! wp_attachment_is_image( $attachment_id ) ) {
                        throw new TW_Core_Exception("IMAGE_UPLOAD_ERROR");
                    }
                    $attachment_ids[] = $attachment_id;
                } catch (TW_Core_Exception $ex) {
                    $errorDetails = [
                        'image' => $fileName
                    ];
                    if(isset($data['sku'])){
                        $errorDetails['sku'] = $data['sku'];
                    } else if(isset($data['id'])){
                        $errorDetails['id'] = $data['id'];
                    }

                    
                    return new WP_Error('tw_core_image_import_error', $ex->getMessage(), $errorDetails);
                }
            }
        }

        if(count($attachment_ids) > 0) {
            $existing_image_ids = is_array($product->get_gallery_image_ids('edit')) ? $product->get_gallery_image_ids('edit') : [];
            foreach($attachment_ids as $id) {
                $existing_image_ids[] = $id;
            }

            $product->set_gallery_image_ids($attachment_ids);
            update_post_meta($product->get_id(), '_product_image_gallery', implode(',', $attachment_ids));
            tw_set_product_image($product);
            //$product->save();
        }
    }
}, PHP_INT_MAX, 2);

//sauvegarde des données parsées
add_filter('woocommerce_product_import_pre_insert_product_object', function(WC_Product $product, $data){
    if($product instanceof TW_Product_Simple || $product instanceof TW_Product_Variable) {
        if(defined_and_not_blank($data['supplier_price'])){
            $product->set_supplier_price($data['supplier_price']);
        }
    
        if(defined_and_not_blank($data['stock_management'])){
            $stock_management_data = [
                'stock_management_mode' => $data['stock_management'],
                'stock_management_url' => defined_and_not_blank($product->get_stock_management_url()) ? $product->get_stock_management_url() : ''
            ];
            $product->set_stock_management_data($stock_management_data);
        }

        if(defined_and_not_blank($data['delivery_method'])){
            $delivery_instance_ids = [];
            foreach($data['delivery_method'] as $instance_id => $detail){
                $delivery_instance_ids[] = $instance_id;
            }
            $product->set_delivery_methods_data($delivery_instance_ids);
        }
    }

    return $product;
}, PHP_INT_MAX, 2);


//TODO probleme dans set_image_data pas de woocommerce_product_import_inserted_product_object
//TODO faire un try catch dans set_image_data (il faudrait faire resortir l'erreur autrement)

add_action('woocommerce_product_import_inserted_product_object', function(WC_Product $product, $data){
    if($product instanceof TW_Product_Simple || $product instanceof TW_Product_Variable) {
        if(defined_and_not_blank($data['supplier_name'])){
            $supplier_data = [
                'product_id' => $product->get_id(),
                'supplier_name' => $data['supplier_name'],
                'restocking_delay' => defined_and_not_blank($data['restocking_delay']) ? $data['restocking_delay'] : null,
                'manage_restocking' => $data['manage_restocking'] == true ? true : false
            ];
            $product->set_supplier_data($supplier_data);
            $product->save_supplier_data();
        }
    }
}, PHP_INT_MAX, 2);

add_action('tw_product_importer_after_import', function(TW_Product_Csv_Importer $importer){
    global $wpdb;
    $product_id_stmt = "SELECT wp.ID, wpm.meta_value
        from wp_posts wp 
        inner join wp_postmeta wpm on (wpm.post_id = wp.ID)
        where wp.post_type = 'product'
        and wpm.meta_key = '_sku'";

    foreach($importer->get_parsed_data() as $row_data) {
        if(isset($row_data['sku']) && defined_and_not_blank($row_data['variable_product_sku'])){
            $product_id = wc_get_product_id_by_sku($row_data['sku']);
            if($product_id !== null) {
                $product = wc_get_product($product_id);
                $product2_stmt =  $product_id_stmt;
                $product2_stmt .= " and wpm.meta_value in (" . tw_prepare_in($row_data['variable_product_sku']) . ")";
                $link_products = $wpdb->get_results($product2_stmt, ARRAY_A);
            
                $link_products_ids = [];
                foreach($link_products as $item) {
                    $link_products_ids[] = $item['ID'];
                }

                if($product !== null && $product instanceof TW_Product_Variable && count($link_products_ids) > 0) {
                    $product->set_variation_data($link_products_ids);
                    $product->save_variation_data();
                }
            }
        }

    }
}, PHP_INT_MAX);

add_filter('woocommerce_product_csv_importer_class', function($importer_class){
    require_once dirname(__DIR__ ). '/classes/tw_product_csv_importer.php';
    return 'TW_Product_Csv_Importer';
}, PHP_INT_MAX, 1);

add_filter('woocommerce_product_importer_time_exceeded', function($time_has_exceeded){
    return false;
}, PHP_INT_MAX, 1);