<?php

function tw_set_product_image(WC_Product $product){
    global $wpdb;

    $gallery_image_ids = get_post_meta($product->get_id(), '_product_image_gallery', true);
    $gallery_image_ids = explode(',', $gallery_image_ids);
    if(count($gallery_image_ids) > 0 && !empty($gallery_image_ids[0])) {
        update_post_meta($product->get_id(), '_thumbnail_id', $gallery_image_ids[0]);
    } else {
        delete_post_meta($product->get_id(), '_thumbnail_id');
    }
}
add_action('woocommerce_create_product', function($product_id, WC_Product $product){
    tw_set_product_image($product);
}, PHP_INT_MAX, 2);

add_action('woocommerce_update_product', function($product_id, WC_Product $product){
    tw_set_product_image($product);
}, PHP_INT_MAX, 2);

add_action('admin_init', function(){
    $js_url = plugin_dir_url(__DIR__) . 'js/admin_gallery.js';
    wp_enqueue_script('tw_core_js_gallery', $js_url, array('jquery'), false, false);

    $css_url = plugin_dir_url(__DIR__) . 'css/admin_gallery.css';
    wp_enqueue_style('tw_core_css_gallery', $css_url);
}, 10, 0);