<?php

add_action('woocommerce_product_options_shipping_product_data', function(){
    global $product_object;
    
    $shipping_methods_options = [];
    $existing_shipping_methods = tw_shipping_methods();
    foreach($existing_shipping_methods as $id => $item) {
      $shipping_methods_options[$id] = $item->title;
    }
  
    include dirname(__DIR__)  . '/templates/delivery_methods_fields.php';
});


add_action('woocommerce_admin_process_product_object', function(WC_Product $product){
    $delivery_methods_data = isset($_POST['delivery_methods']) ? $_POST['delivery_methods'] : '';
    if($product instanceof TW_Product_Simple || $product instanceof TW_Product_Variable) {
        $product->set_delivery_methods_data($delivery_methods_data);
    }
});

add_action('woocommerce_after_product_object_save', function(WC_Product $product, $product_store){
    if($product instanceof TW_Product_Simple || $product instanceof TW_Product_Variable) {
        $product->save_delivery_methods_data();
    }
}, PHP_INT_MAX, 2);