<?php

function tw_core_save_attributes_metadata($meta_value, $object_id, $meta_key) {
	$existing_post_meta_list = get_metadata('post', $object_id);
	$saved_product_attributes = [];

	if(is_array($meta_value)){
		foreach($meta_value as $key => $value) {
			if(!$value['is_taxonomy']){
				if(isset($existing_post_meta_list['_productattribute_' . $key])){
					update_post_meta($object_id, '_productattribute_' . $key, $value['value']);
				} else {
					add_post_meta($object_id, '_productattribute_' . $key, $value['value']);
				}
				$saved_product_attributes[] = '_productattribute_' . $key;
			}
		}
	}

	foreach($existing_post_meta_list as $key => $value) {
		if(strpos($key, '_productattribute_') !== false && strpos($key, '_productattribute_') == 0) {
			if(!in_array($key, $saved_product_attributes)){
				delete_post_meta($object_id, $key);
			}
		}
	}

}

add_action('updated_post_meta', function($meta_id, $object_id, $meta_key, $meta_value){
	if($meta_key == '_product_attributes') {
		tw_core_save_attributes_metadata($meta_value, $object_id, $meta_key);
	}
}, PHP_INT_MAX, 4);

add_action('added_post_meta', function($meta_id, $object_id, $meta_key, $meta_value){
	if($meta_key == '_product_attributes') {
		tw_core_save_attributes_metadata($meta_value, $object_id, $meta_key);
	}
}, PHP_INT_MAX, 4);


function tw_core_clear_unused_attribute(WC_Product $product, $store){
	$existing_attributes = $product->get_attributes();

	try {
		$existing_attributes = array_filter($existing_attributes, function($item){
			if(!($item instanceof WC_Product_Attribute)) {
				throw new \Exception("UNHANDLED_PRODUCT_ATTRIBUTE");
			}

			$value = $item->get_data();
			if($value['is_taxonomy'] == false && ($value['value'] === null || trim($value['value']) == '' || trim($value['value']) == 'null')){
				return false;
			} else {
				return true;
			}
		});
		$product->set_attributes($existing_attributes);
	} catch (\Exception $ex) {}
}
add_action('woocommerce_before_product_object_save', function(WC_Product $product, $store){
	tw_core_clear_unused_attribute($product, $store);
}, PHP_INT_MAX, 2);

function tw_register_custom_attributes_settings() {
	$customAttributes = [];

	if(isset($GLOBALS['tw_product_default_taxonomy'])) {
		foreach($GLOBALS['tw_product_default_taxonomy'] as $taxName) {
			$customAttributes[] = ['label' => ucfirst(strtolower($taxName)), 'value' => $taxName];
		}
	}

	if(isset($GLOBALS['tw_product_default_attributes'])) {
		foreach($GLOBALS['tw_product_default_attributes'] as $attrKey => $attrInfo) {
			$customAttributes[] = ['label' => ucfirst(strtolower($attrKey)), 'value' => $attrKey];
		}
	}

	register_setting(
		'twcore_settings',
		'twcore_custom_attributes_settings',
		[
			'show_in_rest' => true,
			'default' => $customAttributes,
			'type' => 'array',
			'show_in_rest' => [
				'schema' => [
					'type' => 'array',
					'items' => [
						'type' => 'object',
						'properties' => [
							'label' => ['type' => 'string'],
							'value' => ['type' => 'string']
						]
					]
				]
			]
		]
	);
}
add_action('init', 'tw_register_custom_attributes_settings');


function tw_custom_attributes_rest_field(){
	$customAttributes = [];

	if(isset($GLOBALS['tw_product_default_taxonomy'])) {
		foreach($GLOBALS['tw_product_default_taxonomy'] as $taxName) {
			$customAttributes[] = $taxName;
		}
	}

	if(isset($GLOBALS['tw_product_default_attributes'])) {
		foreach($GLOBALS['tw_product_default_attributes'] as $attrKey => $attrInfo) {
			$customAttributes[] = $attrKey;
		}
	}

	$registeredProducts = [];
	foreach($customAttributes as $attrKey) {
		register_rest_field('product', $attrKey, [
			'get_callback' => function($data, $fieldName, $request) use (&$registeredProducts){
				if(preg_match('/product/', $request->get_route()) == 1 || preg_match('/products/', $request->get_route()) == 1) {
					$fieldValue = "";
					if(!in_array($data['id'], $registeredProducts)){
						$registeredProducts[$data['id']] = [
							'attributes' => TW_Factory::getInstance()->getClass(TW_Product_Repository::class)->loadCustomAttributes($data['id']),
							'taxonomy' => TW_Factory::getInstance()->getClass(TW_Product_Repository::class)->loadCustomTaxonomy($data['id'])
						];
					}
					
					if(isset($registeredProducts[$data['id']]['attributes'][$fieldName])){
						$fieldValue = $registeredProducts[$data['id']]['attributes'][$fieldName];
					} else {
						if(isset($registeredProducts[$data['id']]['taxonomy'][$fieldName])){
							$fieldValues = array_keys($registeredProducts[$data['id']]['taxonomy'][$fieldName]);
							$fieldValue = implode(" ", $fieldValues);
						}
					}

					return $fieldValue;
				}
			}
		]);
	}
}
add_action('init', 'tw_custom_attributes_rest_field');
//mettre un hook dans WP_REST_Posts_Controller::prepare_item_for_response

add_action('woocommerce_display_product_attributes', function($product_attributes, $product){
	foreach($product_attributes as $attrKey => $attrDetail) {
		$identifier = $attrKey;
		$identifier = str_replace('attribute_pa_', '', $identifier);
		$identifier = str_replace('attribute_', '', $identifier);

		if(isset($GLOBALS['tw_product_default_attributes']) && isset($GLOBALS['tw_product_default_attributes'][$identifier])){
			if(isset($GLOBALS['tw_product_default_attributes'][$identifier]['label']) && !empty($GLOBALS['tw_product_default_attributes'][$identifier]['label'])){
				$product_attributes[$attrKey]['label'] = $GLOBALS['tw_product_default_attributes'][$identifier]['label'];
			}
		}
	}
	return $product_attributes;
}, PHP_INT_MAX -1, 2);

add_action('woocommerce_attribute_added', function($id, $data){
	global $wp_taxonomies;
	$wp_taxonomies['pa_' . $data['attribute_name']] = [];

	wp_insert_term(
		'non défini',
		'pa_' . $data['attribute_name'],
		[
			'slug' => 'non_defini'
		]
	);
	unset($wp_taxonomies['pa_' . $data['attribute_name']]);
}, PHP_INT_MAX, 2);