<?php


function tw_custom_validation() 
{
    global $tw_metaboxes;
    global $tw_metabox_validation;

    $validated_object = null;
    $validated_subobject = null;
    $validation_rules = [];

	$parsed_url = tw_parse_url($_SERVER['REQUEST_URI']);
    if($parsed_url['post_edition']) {
        $validated_object = 'post';
        $validated_subobject = $parsed_url['edited_post_type'];
    } else if($parsed_url['term_edition']) {
        $validated_object = 'term';
        $validated_subobject = $parsed_url['edited_term_taxonomy'];
    } else if($parsed_url['comment_edition']) {
        $validated_object = 'comment';
    } else if($parsed_url['user_edition']) {
        $validated_object = 'user';
    }

    if($validated_object === null) {
        return;
    }

    /*
    if($tw_metaboxes !== null) {
        foreach($tw_metaboxes as $type_key => $metabox_definition) {
            list($object_type, $object_subtype) = _tw_parse_meta_key_definition_type($type_key);
            foreach($metabox_definition as $metabox_name => $metabox_information) {
                if($object_type == $validated_object) {
                    
                    $process_validation = false;
                    if($object_subtype !== null) {
                        $process_validation = ($validated_subobject !== null && $object_subtype == $validated_subobject) ? true : false;
                    } else {
                        $process_validation = true;
                    }
    
                    if($process_validation) {
                        foreach($metabox_information['meta'] as $meta_information) {
                            
                            if(isset($meta_information['validation']) && count($meta_information['validation']) > 0) {
                                $validation_key = ':input[name=\"' . $meta_information['name'] . '\"]';
                                if(!isset($validation_rules[$validation_key])){
                                    $validation_rules[$validation_key] = ['rules' => []];
                                }
                                
                                foreach($meta_information['validation'] as $rule) {
                                    $validation_rules[$validation_key]['rules'][] = $rule;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    */
    
    //add global validation rule if not allready added
    if(isset($tw_metabox_validation) && !empty($tw_metabox_validation)){
        foreach($tw_metabox_validation as $type_key => $additionnal_validation_rules) {
            list($object_type, $object_subtype) = _tw_parse_meta_key_definition_type($type_key);
            foreach($additionnal_validation_rules as $validation_key => $additionnal_rule) {
                $validation_key = ':input[name=\"' . $validation_key . '\"]';
                if($object_type == $validated_object) {
                    
                    $process_validation = false;
                    if($object_subtype !== null) {
                        $process_validation = ($validated_subobject !== null && $object_subtype == $validated_subobject) ? true : false;
                    } else {
                        $process_validation = true;
                    }
    
                    if($process_validation) {
                        if(!isset($validation_rules[$validation_key])){
                            $validation_rules[$validation_key] = ['rules' => []];
                        }
                        
                        foreach($additionnal_rule as $rule) {
                            $validation_rules[$validation_key]['rules'][] = $rule;
                        }
                    }
                }
            }
        }
    }

    $javascript_validation_rules = "const tw_validation_rules='" . json_encode($validation_rules, JSON_HEX_QUOT) . "';";

    wp_register_script( 'tw_validation', '',);
    wp_enqueue_script( 'tw_validation' );
    wp_add_inline_script( 'tw_validation', $javascript_validation_rules);

    $directory_url = get_bloginfo('url') . '/wp-content/plugins/tw-core';
	wp_enqueue_style('tw_custom_validation', $directory_url . '/css/metabox_custom_validation.css');
	wp_enqueue_script('tw_custom_validation', $directory_url. '/js/metabox_custom_validation.js', array('jquery'), false, true);
}
add_action('admin_init', 'tw_custom_validation', 10, 0);