<?php

/*
function tw_post_type_provider($posts, WP_Query $query) {
    if($query->is_main_query()){
        $postType = ($query->get('post_type') !== null && trim($query->get('post_type')) != "") ? $query->get('post_type') : null;
        if($postType !== null && isset($GLOBALS['tw_post_types']) && isset($GLOBALS['tw_post_types'][$postType])) {
            if(count($posts) == 1) {
                $slug = $query->get($postType);

                $records = TW_Factory::getInstance()->getClass(TW_General_Repository::class)->getCustomPostTypeRecord($postType, $slug);
                $posts[0]->custom_records = $records;
            } else if($query->is_archive()){
                foreach($posts as $index => $item) {
                    $slug = $item->post_name;

                    $records = TW_Factory::getInstance()->getClass(TW_General_Repository::class)->getCustomPostTypeRecord($postType, $slug);
                    $item->custom_records = $records;
                    $posts[$index] = $item;
                }
            }
        }
    }
    return $posts;
}
add_filter('the_posts', 'tw_post_type_provider', PHP_INT_MAX, 2);
 */

 
function _tw_parse_taxonomies_definition_type($key){
    $object_type = null;
    $object_subtype = null;

    $exploded = explode('___', $key);
    if(count($exploded) == 1) {
        $object_type = $exploded[0];
    } else if(count($exploded) == 2) {
        $object_type = $exploded[0];
        $object_subtype = $exploded[1];
    }

    if(!in_array($object_type, array('post'))){
        throw new \Exception("invalid parameter");
    }

    return [$object_type, $object_subtype];
}

function tw_register_taxonomy(){
    global $tw_taxonomies;
    $taxonomies_subtypes = [];

    if($tw_taxonomies !== null) {
        foreach($tw_taxonomies as $type_key => $taxonomy_definition) {
            list($object_type, $object_subtype) = _tw_parse_taxonomies_definition_type($type_key);
            foreach($taxonomy_definition as $tax_name => $tax_info) {
                $allready_registered = false;
    
                $term_to_insert = [];
                if(isset($tax_info['term_to_insert'])){
                    $term_to_insert = $tax_info['term_to_insert'];
                    unset($tax_info['term_to_insert']);
                }
    
                if(!isset($taxonomies_subtypes[$tax_name])){
                    $taxonomies_subtypes[$tax_name] = [$object_subtype];
                } else {
                    $allready_registered = true;
                }
    
                foreach($tw_taxonomies as $tax_to_register_key => $tax_to_register_info) {
                    if(array_keys($tax_to_register_info)[0] == $tax_name) {
                        list($object_to_register_type, $object_to_register_subtype) = _tw_parse_taxonomies_definition_type($tax_to_register_key);
                        if(!in_array($object_to_register_subtype, $taxonomies_subtypes[$tax_name])){
                            $taxonomies_subtypes[$tax_name] = $object_to_register_subtype;
                        }
                    }
                }
    
                if(!$allready_registered) {
                    foreach($term_to_insert as $value) {
                        wp_insert_term($value, $tax_name);
                    }
    
                    register_taxonomy($tax_name, $taxonomies_subtypes[$tax_name], $tax_info);
                }
            }
        }
    }
}
add_action('init', 'tw_register_taxonomy', PHP_INT_MAX - 2);

function tw_register_custom_post_type(){
    global $tw_post_types;

    if($tw_post_types !== null) {
        foreach($tw_post_types as $post_type_key => $post_type_definition) {
            register_post_type($post_type_key, $post_type_definition);
        }
    }
}
add_action('init', 'tw_register_custom_post_type', PHP_INT_MAX - 1);

function tw_disable_block_editor_for_custom_post_type($current_status, $post_type)
{
    if(isset($GLOBALS['tw_post_types']) && isset($GLOBALS['tw_post_types'][$post_type])){
        return false;
    }
    return $current_status;
}
add_filter('use_block_editor_for_post_type', 'tw_disable_block_editor_for_custom_post_type', 10, 2);