<?php
/**
 * https://rudrastyh.com/wordpress/meta-boxes.html
 * TODO voir pour les cas qui ne sont pas single, je ne sais pas comment les gérer
 * TODO s'occuper des custom fields par la suite, et, leur rajouter du contenu
 * 
 * 
 * il faudrait faire une class utils ou je parse l'url (voir tw_custom_validation), réécrire classic_editor.php après
 * il faudrait faire une liste pour les custom post types (pour le moment on fait comme si il n'yen avait pas)
 * 
 * tout doit être préfixé par {object_type___object_subtype} avec object_subtype vide si nécessaire
 * liste meta 
 *      prefix
*              name
    *               single
    *               type
    *               value_default
    *               value_callback*
    *               sanitize_callback*
    *               auth_callback*
    *               show_in_rest*
    *               
    *           
 *        
 *  liste metabox
 *      prefix
 *          name
 *              title
 *              position => par défault normal *
 *              screen *
 *              meta 
 *                  name
 *                  dislay_name
 *                  field_type: image, text, textarea, select, number, date, voir pour les images
 *                  validation: *
 *                      rules
 *                          type
 *                          message
 * 
 * 
 * 
 * liste validation_rules
 *      prefix
 *              name
 *                  inputName
 *                  rules
 *              
 * 
 * au niveau des hooks
 * init
 *      j'ajoute mes meta dans tw_custom_meta
 *          je peux parcourir la liste et ajouter toutes les meta
 *          pour le filtre sur les valeurs  il me faut
 *              object_type
 *              [
    *              subtype => nullable
    *              name
    *              callback
 *              ]
 *              si j'ai un subtype il faut que je vérifie si l'objet correspond au subtype
 *              [
    *              subtype
    *              name
    *              callback
 *              ]
 * 
 *          
 *                  
 *      j'ajoute mes metabox dans tw_custom_metabox je déclare une action admin_menu et save_post si nécesaire
 *      
 * 
 * admin_init
 *     j'ajoute ma validation dans tw_validation (je vais avoir besoin de parser l'url), il faut parser liste_validation_rules et liste_metabox pour en extraire d'autres règles si nécessaire
 *  
 * 
 * étape 1 je créer une classe static utils avec les fonctions nécessaires pour parser la request
 * (
 *  script_name
 *  params
 *  is_admin: true ou false (si la requête commence par wp_admin à modifier avec les extensions qui cachent cette url)
 *  post_edition: true ou false (si post-new.php ou post.php)
 *  post_type: null si pas de post_edition, ou post, page ou custom post type
 * )
 * 
 * 
 * 
 */
function _tw_get_meta_key_definition_type($object_type, $object_subtype = null){
    $definition_type = $object_type;
    if($object_subtype !== null) {
        $definition_type = $object_type . '___' . $object_subtype;
    }

    return $definition_type;
}

function _tw_parse_meta_key_definition_type($key){
    $object_type = null;
    $object_subtype = null;

    $exploded = explode('___', $key);
    if(count($exploded) == 1) {
        $object_type = $exploded[0];
    } else if(count($exploded) == 2) {
        $object_type = $exploded[0];
        $object_subtype = $exploded[1];
    }

    if(!in_array($object_type, array('post', 'comment', 'term', 'user'))){
        throw new \Exception("invalid parameter");
    }

    return [$object_type, $object_subtype];
}

//todo a reformater lorsque l'on fera un script qui fait les metabox
//todo tester sur une valeur seule, sans valeur sur une méta pré calculée
function tw_custom_meta(){
    global $tw_metas;
    $tw_metas = apply_filters('tw_metas', $tw_metas);

    $meta_value_callbacks = [];

    if($tw_metas !== null) {
        foreach($tw_metas as $type_key => $meta_definition) {
            list($object_type, $object_subtype) = _tw_parse_meta_key_definition_type($type_key);
            foreach($meta_definition as $meta_name => $meta_info) {
                $meta_args = [
                    'single' => $meta_info['single'],
                    'type' => $meta_info['type']
                ];

                if(isset($meta_info['value_default'])){
                    $meta_args['default'] = $meta_info['value_default'];
                }
    
                if($object_subtype !== null) {
                    $meta_args['object_subtype'] = $object_subtype;
                }
    
                if(isset($meta_info['sanitize_callback'])){
                    $meta_args['sanitize_callback'] = $meta_info['sanitize_callback'];
                }
    
                if(isset($meta_info['auth_callback'])){
                    $meta_args['auth_callback'] = $meta_info['auth_callback'];
                }
    
                if(isset($meta_info['show_in_rest'])){
                    $meta_args['show_in_rest'] = $meta_info['show_in_rest'];
                }
                
                if(isset($meta_info['value_callback'])){
                    if(!isset($meta_value_callbacks[$object_type])){
                        $meta_value_callbacks[$object_type] = [];
                    }
    
                    $meta_key_definition_type = _tw_get_meta_key_definition_type($object_type, $object_subtype);
                    $meta_value_callbacks[$object_type][] = [
                        'subtype' => $object_subtype,
                        'name' => $meta_name,
                        'callback' => $tw_metas[$meta_key_definition_type][$meta_name]['value_callback']
                    ];
                }
                
                register_meta($object_type, $meta_name, $meta_args);
            }
        }
    }
    
    if(count($meta_value_callbacks) > 0) {
        foreach($meta_value_callbacks as $object_type => $callback_info) {
            $GLOBALS['tw_registered_filters']['get_' . $object_type . '_metadata'] = function($value, $object_id, $meta_key, $single, $meta_type) use ($object_type, $callback_info){
                if(in_array($object_type, array('post', 'term', 'comment'))){
                    $function_name = 'get_' . $object_type;
                    $object_value = call_user_func($function_name, $object_id);
                } else if($object_type == 'user'){
                    $object_value = get_user_by('ID', $object_id);
                } else {
                    $function_name = 'get_' . $object_type;
                    if(function_exists($function_name)){
                        $object_value = call_user_func($function_name, $object_id);
                    } else {
                        throw new \Exception("not implemented");
                    }
                }
                
                if($meta_key == '') {
                    $meta_values = wp_cache_get($object_id, $meta_type . '_meta');
                    if($meta_values === false) {
                        $filter_removed = remove_filter('get_' . $meta_type . '_metadata', $GLOBALS['tw_registered_filters']['get_' . $meta_type . '_metadata'], PHP_INT_MAX -1);
                        $meta_values = get_metadata($meta_type, $object_id);
                        add_filter('get_' . $meta_type . '_metadata', $GLOBALS['tw_registered_filters']['get_' . $meta_type . '_metadata'], PHP_INT_MAX -1, 5);     
                    }

                    foreach($callback_info as $callback_detail) {
                        $should_exec_callback = false;
                        if(!isset($callback_detail['subtype'])){
                            $should_exec_callback = true;
                        }

                        if(isset($callback_detail)){
                            $property_name = $object_type . '_type';
                            if(!property_exists($object_value, $property_name)){
                                throw new \Exception("not implemented");
                            }

                            if($object_value->{$property_name} == $callback_detail['subtype']) {
                                $should_exec_callback = true;
                            }
                        }

                        if($should_exec_callback) {
                            $meta_values[$callback_detail['name']] = [$callback_detail['callback']($object_value, $meta_values)];
                        }
                    }
                    return $meta_values;
                } else {
                    $meta_values = wp_cache_get($object_id, $meta_type . '_meta');
                    if($meta_values === false) {
                        $filter_removed = remove_filter('get_' . $meta_type . '_metadata', $GLOBALS['tw_registered_filters']['get_' . $meta_type . '_metadata'], PHP_INT_MAX -1);
                        $meta_values = get_metadata($meta_type, $object_id);
                        add_filter('get_' . $meta_type . '_metadata', $GLOBALS['tw_registered_filters']['get_' . $meta_type . '_metadata'], PHP_INT_MAX -1, 5);
                    }
                    
                    $has_callback = false;
                    $found_callback_definitions = array_filter($callback_info, function($cb_value) use ($meta_key){
                        return $cb_value['name'] == $meta_key;
                    });
                    if(count($found_callback_definitions) == 1) {
                        return $found_callback_definitions[0]['callback']($object_value, $meta_values);
                    }
                }

                return $value;
            };
            add_filter('get_' . $object_type . '_metadata', $GLOBALS['tw_registered_filters']['get_' . $object_type . '_metadata'], PHP_INT_MAX -1, 5);
        }
    }
}
add_action('init', 'tw_custom_meta', PHP_INT_MAX);

function tw_custom_metaboxes() {
    global $tw_metaboxes;

    if($tw_metaboxes !== null) {
        foreach($tw_metaboxes as $type_key => $box_definition) {
            foreach($box_definition as $box_key => $box_detail) {            
                $screen = null;
                list($object_type, $object_subtype) = _tw_parse_meta_key_definition_type($type_key);
    
                if(isset($box_detail['screen'])){
                    $screen = $box_detail['screen'];
                } else {
                    if($object_type == 'post') {
                        $screen = $object_subtype;
                    } else {
                        $screen = $object_type;
                    }
                }
    
                $box_detail['object_type'] = $object_type;
                $box_detail['box_type'] = $type_key;
                $box_detail['box_id'] = $box_key;
                
                $show = true;
                if(isset($box_detail['visibility_callback'])){
                    $show = $box_detail['visibility_callback']();
                }
    
                if($show) {
                    add_meta_box(
                        $box_key,
                        $box_detail['title'],
                        function($object, $box_detail) {
                             TW_MetaBox::render($box_detail, $object);
                        },
                        $screen,
                        'normal',
                        'default',
                        $box_detail
                     );
                }
            }
        }
    }
}
add_action('add_meta_boxes', 'tw_custom_metaboxes');

function tw_taxonomies_metabox(){
    global $tw_metaboxes;
    
    if($tw_metaboxes !== null) {
        $render_metabox_fn = function($category_slug, $term = null) use ($tw_metaboxes) {
            foreach($tw_metaboxes as $type_key => $box_definition) {
                foreach($box_definition as $box_key => $box_detail) {    
                    list($object_type, $object_subtype) = _tw_parse_meta_key_definition_type($type_key);
        
                    if($object_type != 'term') {
                        continue;
                    }
        
                    if($object_subtype !== null && $object_subtype != $category_slug) {
                        continue;
                    }
                    
                    $box_detail['object_type'] = $object_type;
                    $box_detail['box_type'] = $type_key;
                    $box_detail['box_id'] = $box_key;
        
                    TW_MetaBox::render(['args' => $box_detail], $term);
                }
            }
        };
    
        $taxonomies = get_taxonomies();
        foreach($taxonomies as $taxonomy) {
            add_action($taxonomy . '_add_form_fields', function($taxonomy_slug) use ($render_metabox_fn){
                $render_metabox_fn($taxonomy_slug);
            }, 10, 1);
    
            add_action($taxonomy . '_edit_form_fields', function($term, $taxonomy_slug) use ($render_metabox_fn){
                $render_metabox_fn($taxonomy_slug, $term);
            }, 10, 2);
        }
    }
}
add_action('wp_loaded', 'tw_taxonomies_metabox');

/**
 * personal_options(profile_user) : user_edit
 * user_new_form; user-new.pgp
 */
function tw_user_metabox(){
    global $tw_metaboxes;

    if($tw_metaboxes !== null) {
        $render_metabox_fn = function($user = null) use ($tw_metaboxes){    
            foreach($tw_metaboxes as $type_key => $box_definition) {
                foreach($box_definition as $box_key => $box_detail) {    
                    list($object_type, $object_subtype) = _tw_parse_meta_key_definition_type($type_key);
        
                    if($object_type != 'user') {
                        continue;
                    }
                    
                    $box_detail['object_type'] = $object_type;
                    $box_detail['box_type'] = $type_key;
                    $box_detail['box_id'] = $box_key;
        
                    TW_MetaBox::render(['args' => $box_detail], $user);
                }
            }
        };
    
        add_action('show_user_profile', function($user) use ($render_metabox_fn){
            $render_metabox_fn($user);
        });
        add_action('edit_user_profile', function($user) use ($render_metabox_fn){
            $render_metabox_fn($user);
        });
        add_action('user_new_form', function() use ($render_metabox_fn){
            $render_metabox_fn();
        });
        add_action('network_user_new_form', function() use ($render_metabox_fn){
            $render_metabox_fn();
        });
    }
}
add_action('init', 'tw_user_metabox', PHP_INT_MAX);

/**
 * post -> save_post
 * comment -> (comment_post, edit_comment)
 * term -> (create_term, edit_term)
 * user -> (user_register, profile_update)
 * 
 * je fais faire un seul handler pour chaque type
 * je vais vérifier l'existence des champs dans $_POST peut être en checkant le _nonce
 * pour chaque meta, présent dans la metabox, je vais faire un update_meta
 * 
 */
function tw_save_metaboxes() {
    global $tw_metaboxes;
    global $tw_metas;
    global $tw_taxonomies;
    
    $tw_metas = apply_filters('tw_metas', $tw_metas);

    if($tw_metaboxes !== null && ($tw_metas !== null || $tw_taxonomies !== null)) {
        $saveFunction = function($type_key, $object_type, $args) use ($tw_metaboxes, $tw_metas){
            $submitted_metabox_keys = [];
    
            foreach($tw_metaboxes[$type_key] as $meta_key => $meta_definition) {
                list($nonce_name, $nonce_phrase) = TW_MetaBox::nonceDefinition($meta_key);
                if(isset($_POST[$nonce_name])){
                    $submitted_metabox_keys[] = str_replace('_nonce', '', $nonce_name);
                }
            }
    
            foreach($submitted_metabox_keys as $submitted_key) {
                list($nonce_name, $nonce_phrase) = TW_MetaBox::nonceDefinition($submitted_key);
                $nonce_value = wp_create_nonce($nonce_phrase);
                if($nonce_value !== $_POST[$nonce_name]){
                    throw new \Exception("invalid metabox");
                }
    
                $metabox_definition = $tw_metaboxes[$type_key][$submitted_key];
                foreach($metabox_definition['fields'] as $item) {
                    if(is_string($item)){
                        $matching_meta_definition = isset($tw_metas[$type_key][$item]['metabox_field']) ? $tw_metas[$type_key][$item]['metabox_field'] : null;
                        $matching_taxonomy_definition = isset($tw_taxonomies[$type_key][$item]) ? $tw_taxonomies[$type_key][$item] : null;

                        if($matching_meta_definition !== null) {
                            $meta_key = $item;
                            if($matching_meta_definition !== null && isset($matching_meta_definition['input_name'])){
                                $meta_value = $_POST[$matching_meta_definition['input_name']];
                            } else {
                                $meta_value = $_POST[$meta_key];
                            }
            
                            $object_id = $args['object_id'];
                            $should_save = apply_filters('tw_meta_save', true, [
                                'object_type' => $object_type,
                                'object_id' => $object_id,
                                'meta_key' => $meta_key,
                                'meta_value' => $meta_value
                            ]);

                            if($should_save == true) {
                                update_metadata($object_type, $object_id, $meta_key, $meta_value);
                            }
                        } else if($matching_taxonomy_definition !== null) {
                            //by default taxonomies are saved elsewhere
                        }
                    } else if($item instanceof TW_MetaRow) {
                        foreach($item->getItems() as $subItem) {
                            $matching_meta_definition = isset($tw_metas[$type_key][$subItem]['metabox_field']) ? $tw_metas[$type_key][$subItem]['metabox_field'] : null;
                            $matching_taxonomy_definition = isset($tw_taxonomies[$type_key][$subItem]) ? $tw_taxonomies[$type_key][$subItem] : null;

                            if($matching_meta_definition !== null) {
                                $meta_key = $subItem;

                                if($matching_meta_definition !== null && isset($matching_meta_definition['input_name'])){
                                    $meta_value = $_POST[$matching_meta_definition['input_name']];
                                } else {
                                    $meta_value = $_POST[$meta_key];
                                }
                
                                $object_id = $args['object_id'];
                                $should_save = apply_filters('tw_meta_save', true, [
                                    'object_type' => $object_type,
                                    'object_id' => $object_id,
                                    'meta_key' => $meta_key,
                                    'meta_value' => $meta_value
                                ]);

                                if($should_save == true) {
                                    update_metadata($object_type, $object_id, $meta_key, $meta_value);
                                }
                            } else if($matching_taxonomy_definition !== null) {
                                //by default taxonomies are saved elsewhere
                            }
                        }
                    }                 
                }
            }
        };

        foreach($tw_metaboxes as $type_key => $box_definition) {
            list($object_type, $object_subtype) = _tw_parse_meta_key_definition_type($type_key);
    
            if($object_type == 'post') {
                add_action('save_post', function($post_id, $post, $update) use ($type_key, $object_type, $saveFunction){
                    $saveFunction($type_key, $object_type, [
                        'object_id' => $post_id,
                        'object' => $post
                    ]);
                }, 10, 3);
            } else if($object_type == 'comment') {
                add_action('comment_post', function($comment_id, $comment_approved, $comment_data) use ($type_key, $object_type, $saveFunction){
                    $comment = get_comment($comment_id);
                    $saveFunction($type_key, $object_type, [
                        'object_id' => $comment_id,
                        'object' => $comment
                    ]);
                }, 10, 3);
    
                add_action('edit_comment', function($comment_id, $comment_data) use ($type_key, $object_type, $saveFunction){
                    $comment = get_comment($comment_id);
                    $saveFunction($type_key, $object_type, [
                        'object_id' => $comment_id,
                        'object' => $comment
                    ]);
                }, 10, 2);
            } else if($object_type == 'term') {
                add_action('create_term', function($term_id, $tt_id, $taxonomy, $args) use ($type_key, $object_type, $saveFunction){
                    $term = get_term($term_id);
                    $saveFunction($type_key, $object_type, [
                        'object_id' => $term_id,
                        'object' => $term
                    ]);
                }, 10, 4);
    
                add_action('edit_term', function($term_id, $tt_id, $taxonomy, $args) use ($type_key, $object_type, $saveFunction){
                    $term = get_term($term_id);
                    $saveFunction($type_key, $object_type, [
                        'object_id' => $term_id,
                        'object' => $term
                    ]);
                }, 10, 4);
            } else if($object_type == 'user') {
                add_action('user_register', function($user_id, $user_data) use ($type_key, $object_type, $saveFunction){
                    $user = get_user_by('ID', $user_id);
                    $saveFunction($type_key, $object_type, [
                        'object_id' => $user_id,
                        'object' => $user
                    ]);
                }, 10, 2);
    
                add_action('profile_update', function($user_id, $old_user_data, $user_data) use ($type_key, $object_type, $saveFunction){
                    $user = get_user_by('ID', $user_id);
                    $saveFunction($type_key, $object_type, [
                        'object_id' => $user_id,
                        'object' => $user
                    ]);
                }, 10, 3);
            }
        }
    }
}
add_action('init', 'tw_save_metaboxes', PHP_INT_MAX);