<?php

function tw_shipping_methods(){
    global $wpdb;
    $shipping_methods = [];

    $zones = [];
    $shipping_zones = $wpdb->get_results(
        $wpdb->prepare("SELECT * FROM wp_woocommerce_shipping_zone_methods"),
        ARRAY_A
    );

    foreach($shipping_zones as $item) {
        if(!in_array($item['zone_id'], $zones)){
            $zones[] = $item['zone_id'];
        }
    }

    foreach($zones as $zone) {
        $shipping_zone = new WC_Shipping_Zone($zone);
        $methods = $shipping_zone->get_shipping_methods();

        foreach($methods as $method) {
            $shipping_methods[$method->instance_id] = $method;
        }
    }

    return $shipping_methods;
}