<?php

/**
 * TODO faire le bloc en js et modifier le code php
 */
class TwFlushCommand {
    public function flush()
    {
        global $wpdb;
        $wpdb->query("DELETE FROM wp_options where option_name like '%tw_post_type%'");
        
        foreach($GLOBALS['tw_post_types'] as $postTypeKey => $postTypeDetail) {
            $encoded = null;
            try {
                $encoded = json_encode($postTypeDetail);
                $encoded = hash('sha256', $encoded);
            } catch (Exception $ex) {
                WP_CLI::error($ex->getMessage());
            }

            if($encoded !== null) {
                $wpdb->query(
                    $wpdb->prepare(
                        "INSERT INTO wp_options(option_name, option_value, autoload) VALUES(%s,%s,%s)",
                        ['tw_post_type_' . $postTypeKey, $encoded, 'no']
                    )
                );
            }
        }
        flush_rewrite_rules(true);
        WP_CLI::success("OK");
    }
}
add_action('cli_init', function(){
    WP_CLI::add_command('tw_flush_command', 'TwFlushCommand');
});