<?php

trait TW_Variation_Trait {
    protected $cache_variation_data = null;
    public $variation_data = null;

    public function set_variation_data($variation_data){
        $this->variation_data = $variation_data;
    }

    public function get_variation_data($format = null){
        global $wpdb;

        if($this->cache_variation_data === null) {
            $this->cache_variation_data = $wpdb->get_results(
                $wpdb->prepare("SELECT wp.post_title as target_product_name, tvp.* 
                FROM tw_variable_product tvp
                LEFT JOIN wp_posts wp on (wp.ID = tvp.target_product_id) 
                WHERE tvp.product_id = %d", [$this->get_id()]),
                ARRAY_A
            );

            if($this->cache_variation_data !== null) {
                if(count($this->cache_variation_data) < 1) {
                    $this->set_prop('variation_data', []);
                } else {
                    $variation_data = [];
                    for($i=0;$i<count($this->cache_variation_data); $i++){
                        $item = $this->cache_variation_data[$i];

                        if($i > 0) {
                            $variation_data[$item['target_product_id']] = 'scotch jaune ' . $i;
                        } else {
                            $variation_data[$item['target_product_id']] = 'scotch jaune';
                        }
                    }
                    $this->set_prop('variation_data', $variation_data);
                }
            }
        }

        if($format === null) {
            return $this->get_prop('variation_data');
        } else {
            $variation_data = [];
            if($format == 'option') {
                for($i=0;$i<count($this->cache_variation_data); $i++){
                    $item = $this->cache_variation_data[$i];
                    $variation_data[$item['target_product_id']] = $item['target_product_name'];
                }
            } else if($format == 'ids') {
                for($i=0;$i<count($this->cache_variation_data); $i++){
                    $item = $this->cache_variation_data[$i];
                    $variation_data[] = $item['target_product_id'];
                }
            }
            return $variation_data;
        }
    }

    public function save_variation_data(){
        global $wpdb;
        $variation_data = $this->variation_data;

        if($variation_data !== null) {
            $wpdb->delete(
                'tw_variable_product',
                [
                    'product_id' => $this->id
                ]
            );

            foreach($variation_data as $variation_id){
                $wpdb->insert(
                    'tw_variable_product',
                    [
                        'product_id' => $this->id,
                        'target_product_id' => $variation_id
                    ]
                );
            }
            $this->cache_variation_data = null;
        }
    }
}