<?php

trait TW_Supplier_Trait {
    protected $cache_supplier_data = null;
    public $supplier_data = null;
    
    protected $cache_supplier_price = null;
    public $supplier_price = null;

    public function get_supplier_data($property_name){
        global $wpdb;

        if($this->cache_supplier_data === null) {
            $this->cache_supplier_data = $wpdb->get_row(
                $wpdb->prepare("SELECT * FROM tw_supplier_product where product_id = %d and variation_id is null", [$this->get_id()]),
                ARRAY_A
            );

            if($this->cache_supplier_data !== null) {
                $this->set_prop('supplier_name', $this->cache_supplier_data['supplier_name']);
                $this->set_prop('restocking_delay', $this->cache_supplier_data['restocking_delay']);
                $this->set_prop('manage_restocking', $this->cache_supplier_data['manage_restocking']);
                $this->set_prop('supplier_restocking_url', $this->cache_supplier_data['supplier_restocking_url']);
            }        
        }
        return $this->get_prop($property_name);
    }

    public function set_supplier_data($supplier_data){
        $this->supplier_data = $supplier_data;
    }


    public function save_supplier_data() {
        global $wpdb;
        $supplier_data = $this->supplier_data;

        if($supplier_data !== null) {
            $existing_supplier_data = $wpdb->get_results(
                $wpdb->prepare("SELECT * FROM tw_supplier_product where product_id = %d and variation_id is null", [$this->get_id()]),
                ARRAY_A
            );
    
            foreach($existing_supplier_data as $res) {
                $wpdb->delete(
                    'tw_supplier_product',
                    ['id' => $res['id']]
                );
            }
            if($supplier_data['supplier_name'] === null) {
                return;
            }
            $wpdb->insert(
                'tw_supplier_product',
                $supplier_data
            );
            $this->cache_supplier_data = null;
        }
    }

    public function get_supplier_price(){
        if($this->cache_supplier_price === null) {
            $this->cache_supplier_price = get_post_meta($this->get_id(), 'supplier_price', true);
        }
        return $this->cache_supplier_price;
    }

    public function set_supplier_price($supplier_price){
        $this->supplier_price = $supplier_price;
    }

    public function save_supplier_price() {
        $supplier_price = $this->supplier_price;
        if($supplier_price !== null) {
            delete_post_meta($this->get_id(), 'supplier_price');
            if(trim($supplier_price) != '' && filter_var($supplier_price, FILTER_VALIDATE_FLOAT) !== false) {
                add_post_meta($this->get_id(), 'supplier_price', $supplier_price);
            }

            $this->cache_supplier_price = null;
        }
    }
}