<?php

class TW_Stylesheet {
    private $selectors = [];
    private $rules = [];
    private $mediaQueries = [];
    private $rulesType = [];

    public function addRules($selector, $rules) {
        $this->selectors[] = $selector;

        if(!is_array($rules)){
            $rules = [$rules];
        }
        $this->rules[] = $rules;
        $this->rulesType[] = "classic";
        $this->mediaQueries[] = null;
    }

    public function addMediaRules($selector, $mediaQuery, $rules) {
        $this->selectors[] = $selector;

        if(!is_array($rules)){
            $rules = [$rules];
        }
        $this->rules[] = $rules;
        $this->rulesType[] = "media";
        $this->mediaQueries[] = $mediaQuery;
    }

    public function generateStyleSheet() {
        $generatedStyleSheet = "";
        for($i=0;$i<count($this->selectors); $i++) {
            $ruleType = $this->rulesType[$i];

            if($ruleType == "media") {
                $generatedStyleSheet .= $this->mediaQueries[$i] . " {" . "\n";
            }

            $generatedStyleSheet .= $this->selectors[$i] . " {" . "\n";
            foreach($this->rules[$i] as $key => $value) {
                $generatedStyleSheet .= $key . ": " . $value . ";" . "\n"; 
            }

            if($ruleType == "media") {
                $generatedStyleSheet .= "}" . "\n";
            }
            $generatedStyleSheet .= "}" . "\n\n";
        }
        return $generatedStyleSheet;
    }
}