<?php

defined( 'ABSPATH' ) || exit;

class TW_Product_Variable extends WC_Product_Simple {
    use TW_Supplier_Trait;
    use TW_Stock_Management_trait;
    use TW_Delivery_Trait;
    use TW_Variation_Trait;
    use TW_Attributes_Trait;

    public function get_type() {
        return 'simple-with-variations';
    }

    public function __construct($product = 0)
    {        
        parent::__construct($product);
        $this->supports[] = 'ajax_add_to_cart';

        if(isset($GLOBALS['tw_supplier_informations']) && count($GLOBALS['tw_supplier_informations']) > 0) {
            foreach($GLOBALS['tw_supplier_informations'] as $info_key => $info_value) {
                $this->data[$info_key] = '';
            }
        }
        $this->data['stock_management_mode'] = '';
        $this->data['stock_management_url'] = '';
        $this->data['delivery_methods'] = [];
        $this->data['variation_data'] = [];

        $this->_prefill_custom_attributes_with_default_value();
        $this->loadCustomAttributes($this->get_id());
        $this->loadCustomTaxonomy($this->get_id());
        do_action('tw_product_variable_new', $this);
    }

    public function set_image_id($image_id = '') {
        $gallery_ids = $this->get_gallery_image_ids('edit');

        if(!empty($image_id) && count($gallery_ids) == 0){
            parent::set_gallery_image_ids([$image_id]);
        }
        parent::set_image_id($image_id);
    }

    /**
	 * Get the add to url used mainly in loops.
	 *
	 * @return string
	 */
	public function add_to_cart_url() {
		$url = $this->is_purchasable() && $this->is_in_stock() ? remove_query_arg(
			'added-to-cart',
			add_query_arg(
				array(
					'add-to-cart' => $this->get_id(),
				),
				( function_exists( 'is_feed' ) && is_feed() ) || ( function_exists( 'is_404' ) && is_404() ) ? $this->get_permalink() : ''
			)
		) : $this->get_permalink();
		return apply_filters( 'woocommerce_product_add_to_cart_url', $url, $this );
	}

	/**
	 * Get the add to cart button text.
	 *
	 * @return string
	 */
	public function add_to_cart_text() {
		$text = $this->is_purchasable() && $this->is_in_stock() ? __( 'Add to cart', 'woocommerce' ) : __( 'Read more', 'woocommerce' );

		return apply_filters( 'woocommerce_product_add_to_cart_text', $text, $this );
	}

	/**
	 * Get the add to cart button text description - used in aria tags.
	 *
	 * @since 3.3.0
	 * @return string
	 */
	public function add_to_cart_description() {
		/* translators: %s: Product title */
		$text = $this->is_purchasable() && $this->is_in_stock() ? __( 'Add to cart: &ldquo;%s&rdquo;', 'woocommerce' ) : __( 'Read more about &ldquo;%s&rdquo;', 'woocommerce' );

		return apply_filters( 'woocommerce_product_add_to_cart_description', sprintf( $text, $this->get_name() ), $this );
	}
}