<?php
require_once ABSPATH . 'wp-content/plugins/woocommerce/includes/import/class-wc-product-csv-importer.php' ;

class TW_Product_Csv_Importer extends WC_Product_CSV_Importer {

    private $_overloaded_filters = [];

    public function __construct($file, $params = array())
    {
        $this->_overloaded_filters['sanitize_file_name_chars'] = function($special_chars, $filename_raw){
            return array( '?', '[', ']', '\\', '=', '<', '>', ':', ';', ',', "'", '"', '&', '$', '#', '*', '(', ')', '|', '~', '`', '!', '{', '}', '%', '+', '’', '«', '»', '”', '“', chr( 0 ) );
        };
        add_filter(
            'sanitize_file_name_chars', 
            $this->_overloaded_filters['sanitize_file_name_chars'],
            PHP_INT_MAX,
        2); 
        parent::__construct($file, $params);
    }
    
    /*
    private $tw_custom_taxonomies_column = [];
    private $tw_custom_attributes_column = [];

    public function add_custom_taxonomie_column($columnName, $columnValue){
        $this->tw_custom_attributes_column[columnName]
    }
    */

    public function parse_stock_management_field($value)
    {
        $parsed_value = null;
        $possible_values = array_keys(TW_Core_Enum::stock_management_mode());
        if(in_array($value, $possible_values)){
            $parsed_value = $value;
        }

        return $parsed_value;
    }

    public function parse_delivery_method_field($value) {
        $parsed_values = [];
        $values = explode(',', $value);

        $possible_values = [];
        foreach(tw_shipping_methods() as $id => $item) {
            $possible_values[strtolower($item->title)] = $item;
        }
        
        foreach($values as $item) {
            if(in_array(trim(strtolower($item)), array_keys($possible_values))){
                $delivery_method = $possible_values[trim(strtolower($item))];
                $parsed_values[$delivery_method->instance_id] = $delivery_method;
            }
        }
        return $parsed_values;
    }

    protected $cache_existing_skus = null;
    protected $cache_parsed_skus = null;

    /**
     * TODO retourner le résultat du cache
     */
    public function parse_variable_product_sku($cell_sku){
        global $wpdb;
        $parsed_cell_sku = [];

        if($this->cache_existing_skus === null) {
            $product_query = new WC_Product_Query([
                'type' => 'simple-with-variations',
                'fields' => 'ids',
                'cache_results' => false
            ]);
            $product_ids = $product_query->get_products();
    
            $skus = [];
            if(count($product_ids) > 0) {
                $skus = $wpdb->get_results(
                    $wpdb->prepare("SELECT wpm.post_id, wpm.meta_value
                        FROM wp_postmeta wpm
                        WHERE wpm.post_id in (%d)
                        AND wpm.meta_key = '_sku'
                    ", [tw_explode_ids($product_ids)]),
                    ARRAY_N
                );
            }
            $this->cache_existing_skus = $skus;
        }

        if($this->cache_parsed_skus === null) {
            $cache_parsed_skus = [];
            foreach($this->parsed_data as $row_key => $row_value) {
                if(
                    isset($row_value['sku'])
                    && $row_value['sku'] !== null
                    && trim($row_value['sku']) != ''
                ){
                    $cache_parsed_skus[] = trim($row_value['sku']);
                }
            }
            $this->cache_parsed_skus = $cache_parsed_skus;
        }


        $all_skus = array_merge(array_values($this->cache_existing_skus), array_values($this->cache_parsed_skus));
        
        $exploded_cell_sku = explode(',', $cell_sku);
        foreach($exploded_cell_sku as $item) {
            $item = trim($item);
            if(in_array($item, $all_skus)){
                $parsed_cell_sku[] = $item;
            }
        }

        return $parsed_cell_sku;
    }

    protected $cache_existing_taxonomies = [];
    public function parse_taxonomy($taxonomyName, $cellValue)
    {
        $parsed_values = [];

        if(!isset($cache_existing_taxonomies[strtolower($taxonomyName)])){
            $this->cache_existing_taxonomies[strtolower($taxonomyName)] = tw_get_taxonomy_values($taxonomyName, "TERM");
        }


        $cellValue = explode(',', $cellValue);
        if(count($this->cache_existing_taxonomies[strtolower($taxonomyName)]) > 0){
            foreach($cellValue as $item) {
                if(in_array(strtolower($item), $this->cache_existing_taxonomies[strtolower($taxonomyName)])){
                    $parsed_values[] = strtolower($item);
                } else {
                    $parsed_values[] = strtolower($item);
                }
            }
        }
        return $parsed_values;
    }

    protected function expand_data($data)
    {
        $data = parent::expand_data($data);
        if(!is_array($data['raw_gallery_image_ids'])){
            $data['raw_gallery_image_ids'] = [];
        }

        if(isset($data['raw_image_id']) && !empty($data['raw_image_id'])){
            array_unshift($data['raw_gallery_image_ids'], $data['raw_image_id']);
        }

        return apply_filters('tw_importer_expand_data', $data, $this);
    }

    protected function read_file(){
        $mapping = apply_filters('tw_product_importer_before_read_file', $this->params['mapping']);
        $this->params['mapping'] = $mapping;

        parent::read_file();
    }

    protected $processed_image_errors = [];

    protected function set_image_data(&$product, $data){
        $newData = $data;
        $tmp_upload_url = ABSPATH . 'tmp_uploads';

        if(isset($newData['raw_image_id'])){
            if(strpos($newData['raw_image_id'], 'tmp_uploads/') !== false) {
                $newData['raw_image_id'] = '';
           }
        }

        $raw_gallery_image_ids = [];
        if(is_array($newData['raw_gallery_image_ids']) && count($newData['raw_gallery_image_ids']) > 0){
            foreach($newData['raw_gallery_image_ids'] as $image_id) {
                if(strpos($image_id, 'tmp_uploads/') === false) {
                    $raw_gallery_image_ids[] = $image_id;
                }
            }
            $newData['raw_gallery_image_ids'] = $raw_gallery_image_ids;
        }        

        try {
            parent::set_image_data($product, $newData);
        } catch(\Exception $ex) {
            $errorDetail = [
                'row' => $this->get_row_id($newData)
            ];

            $this->processed_image_errors[] = new WP_Error(
                'tw_core_image_import_error', 
                $ex->getMessage(), 
                $errorDetail
            );
        }
    }
    
    public function import(){
        $this->parsed_data = apply_filters('tw_product_importer_before_import', $this->parsed_data, $this);
        $import_results = parent::import();
        do_action('tw_product_importer_after_import', $this);
        
        if(count($this->processed_image_errors) > 0) {
            foreach($this->processed_image_errors as $item) {
                if(!isset($import_results['imported_with_errors'])){
                    $import_results['imported_with_errors'] = [];
                }

                $import_results['imported_with_errors'][] = $item;
            }
        }
        return $import_results;

        foreach($this->_overloaded_filters as $filer_name => $fn) {
            remove_filter($filer_name, $fn, PHP_INT_MAX);
        }
    }
}