<?php

trait TW_Delivery_Trait {
    protected $cache_delivery_methods_data = null;
    public $delivery_methods_data = null;

    public function get_delivery_methods_data(){
        global $wpdb;

        if($this->cache_delivery_methods_data === null) {
            $this->cache_delivery_methods_data = $wpdb->get_results(
                $wpdb->prepare("SELECT * FROM tw_delivery_product where product_id = %d", [$this->get_id()]),
                ARRAY_A
            );

            if($this->cache_delivery_methods_data !== null) {
                if(count($this->cache_delivery_methods_data) < 1) {
                    $this->set_prop('delivery_methods', []);
                } else {
                    $delivery_methods = [];
                    foreach($this->cache_delivery_methods_data as $item) {
                        $delivery_methods[] = $item['delivery_instance_id'];
                    }
                    $this->set_prop('delivery_methods', $delivery_methods);
                }
            }        
        }
        return $this->get_prop('delivery_methods');
    }

    public function set_delivery_methods_data($delivery_methods_data){
        $this->delivery_methods_data = $delivery_methods_data;
    }


    public function save_delivery_methods_data() {
        global $wpdb;
        $delivery_methods_data = $this->delivery_methods_data;

        if($delivery_methods_data !== null) {
            $existing_delivery_methods = $wpdb->get_results(
                $wpdb->prepare("SELECT * FROM tw_delivery_product where product_id = %d", [$this->get_id()]),
                ARRAY_A
            );
    
            foreach($existing_delivery_methods as $res) {
                $wpdb->delete(
                    'tw_delivery_product',
                    ['id' => $res['id']]
                );
            }
            if(!is_array($delivery_methods_data) || count($delivery_methods_data) < 1) {
                return;
            }
            foreach($delivery_methods_data as $item) {
                $data = [
                    'product_id' => $this->get_id(),
                    'delivery_instance_id' => (int)$item
                ];

                $wpdb->insert(
                    'tw_delivery_product',
                    $data
                );
            }
            $this->cache_delivery_methods_data = null;
        }
    }
}
