<script type="text/javascript">

  document.addEventListener("DOMContentLoaded", (event) => {
    let selectedColor = null;
    <?php if ($args['selectedColor'] !== null) { ?>
        selectedColor = <?php echo "'" . $args['selectedColor'] . "'"; ?>;
    <?php } ?>


    const sizesListJSON = '<?php echo json_encode($args['sizesList'], JSON_HEX_QUOT | JSON_HEX_TAG) ?>';
    const sizeList = JSON.parse(sizesListJSON);
    const colorListJSON = '<?php echo json_encode($args['colorList'], JSON_HEX_QUOT | JSON_HEX_TAG) ?>';
    const colorList = JSON.parse(colorListJSON);
    const urlListJSON = '<?php echo json_encode($args['urlList'], JSON_HEX_QUOT | JSON_HEX_TAG) ?>';
    const urlList = JSON.parse(urlListJSON);


    function refreshPageWithSelectedVariation(desiredColor = null)
    {
        let size = document.querySelector('#clothesVariationSize').value;
        if(desiredColor === null && selectedColor !== null) {
            desiredColor = selectedColor;
        }

        let productVariationId = "";
        if(desiredColor !== null && Object.keys(colorList).length > 0 && typeof(colorList[size + '_' + desiredColor]) != "undefined") {
            productVariationId = colorList[size + '_' + desiredColor]['product_id'];
        } else {
            productVariationId = sizeList[size][0];
        }

        let url = urlList[productVariationId];
        window.location.href = url;
    }

    document.querySelector('#clothesVariationSize').addEventListener('change', function(e){
        refreshPageWithSelectedVariation();
    });
    
    document.querySelectorAll('.clothesVariationColorSelector').forEach((elem) => {
        elem.addEventListener('click', function(e){
            let colorKey = e.target.closest('li').getAttribute('data-key');
            colorKey = colorKey.split('_');
            refreshPageWithSelectedVariation(colorKey[1]);
        });
    });
  });

</script>
<?php if(count($args['sizesList']) > 0 || count($args['colorList']) > 0) { ?>
    <div class="tw-clothes-variations">
    <?php if(count($args['sizesList']) > 0) { ?>
        <div class="sizes">
            <label>Taille</label>
            <select name="clothesVariationSize" id="clothesVariationSize">
                <?php foreach($args['sizesList'] as $sizeKey => $sizeDetail) { 
                    if($sizeKey == $args['selectedSize']) { ?>
                        <option selected="selected" data-key="<?php echo $sizeKey; ?>" value="<?php echo $sizeKey;?>">
                            <?php echo strtoupper($sizeKey); ?>
                        </option>
                    <?php } else { ?>
                        <option data-key="<?php echo $sizeKey; ?>" name="<?php echo $sizeKey;?>" value="<?php echo $sizeKey;?>">
                            <?php echo strtoupper($sizeKey); ?>
                        </option>
                    <?php } ?>
                <?php } ?>
            </select>
        </div>

        <div class="colors">
            <label>Couleur</label>
            <ul>
                <?php foreach($args['colorList'] as $colorKey => $item) {
                    $sizeName = explode("_", $colorKey);
                    $sizeName = $sizeName[0];
                    $colorName = explode("_", $colorKey);
                    $colorName = $colorName[1];

                    $style = [];
                    $style[] = 'background-color:' . $item['hex'];
                    $style[] = 'opacity:0.6';

                    $isColorSelected = false;
                    if($args['selectedColor'] !== null && $colorName == $args['selectedColor']) {
                        $isColorSelected = true;
                    }
                     ?>
                    <li class="clothesVariationColorSelector" style="<?php if(strstr($sizeName, $args['selectedSize']) === false){ echo "display:none;"; } ?>"  data-key="<?php echo $colorKey; ?>">
                        <?php if($isColorSelected == true) { ?>
                            <span class="selectedColor"></span>
                        <?php } ?>
                        <span style="<?php echo implode(';', $style); ?>"></span>
                        <?php echo $colorName; ?>
                    </li>
                    <?php 
                }
                 ?>
            </ul>
        </div>
    <?php } ?>
    </div>
<?php } ?>