<?php
class TW_WIDGET_ProductVariationSelector extends \Elementor\Widget_Base {


	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);

		$style_url = dirname(get_stylesheet_uri()) . '/widgets/productVariationSelector/style.css';
		wp_register_style('productVariationSelectorStyle', $style_url);
	}

	public function get_style_depends() {
		return [ 'productVariationSelectorStyle' ];
	}

	protected function is_dynamic_content(): bool {
		return true;
	}

	public function get_name() {
		return 'tw_productvariation_selector';
	}

	public function get_title() {
		return esc_html__( 'Sélecteur de variations produits', 'tw-theme' );
	}

	public function get_icon() {
		return 'eicon-select';
	}

	public function get_categories() {
		return [ 'woocommerce-elements-single' ];
	}

	public function get_keywords() {
		return ['product', 'selector', 'variation'];
	}

	protected function render() {
		global $post;
		$settings = $this->get_settings_for_display();

		if($post !== null && $post->post_type == 'product'){
			$product_id = $post->ID;
			$product = wc_get_product($post);
	
			$sizesList = [];
			$colorList = [];
			$urlList = [];
	
			if($product instanceof TW_Product_Variable) {
				$linkedProductIds = TW_Factory::getInstance()->getClass(TW_Product_Repository::class)->linkedProductIds($product_id);
				$linkedTaxonomies = TW_Factory::getInstance()->getClass(TW_Product_Repository::class)->loadCustomTaxonomy($linkedProductIds);
	
				$sizesList = [];
				foreach($linkedProductIds as $linkedId) {
					if(isset($linkedTaxonomies[$linkedId]['size']) && count($linkedTaxonomies[$linkedId]['size']) > 0){
						foreach($linkedTaxonomies[$linkedId]['size'] as $sizeName => $sizeDetail) {
							if(!isset($sizesList[$sizeDetail['slug']])){
								$sizesList[$sizeDetail['slug']] = [];
							}
	
							if(!in_array($linkedId, $sizesList[$sizeDetail['slug']])){
								$sizesList[$sizeDetail['slug']][] = $linkedId;
							}
	
							if(!isset($urlList[$linkedId])){
								$urlList[$linkedId] = get_permalink($linkedId);
							}
						}
					}
				}
				
				foreach($sizesList as $sizeSlug => $sizeDetail) {
					foreach($sizeDetail as $selectedProductId) {
						if(isset($linkedTaxonomies[$selectedProductId]['color']) && count($linkedTaxonomies[$selectedProductId]['color']) > 0){
							foreach($linkedTaxonomies[$selectedProductId]['color'] as $colorName => $colorDetail) {
								$colorList[$sizeSlug . '_' . $colorDetail['slug']] = [
									'product_id' => $selectedProductId,
									'hex' => $linkedTaxonomies[$selectedProductId]['color'][$colorName]['description']
								];
	
								if(!isset($urlList[$selectedProductId])){
									$urlList[$selectedProductId] = get_permalink($linkedId);
								}
							}
						}
					}
				}
	
				$selectedSize = null;
				$tmpSize = $product->getCustomAttributesOrTaxonomy('size', "SLUG");
				if(is_array($tmpSize) && count($tmpSize) > 0) {
					$selectedSize = $tmpSize[0];
				}
	
				$selectedColor = null;
				$tmpColor = $product->getCustomAttributesOrTaxonomy('color', "SLUG");
				if(is_array($tmpColor) && count($tmpColor) > 0) {
					$selectedColor = $tmpColor[0];
				}
			}
			
	
			$templatePath = realpath(__DIR__. '/template.php');
			$templateVars = [
				'sizesList' => $sizesList,
				'colorList' => $colorList,
				'urlList' => $urlList,
				'selectedSize' => $selectedSize,
				'selectedColor' => $selectedColor
			];
	
			ob_start();
			load_template($templatePath, false, $templateVars);
			$tplContent = ob_get_contents();
			ob_end_clean();
	
			echo $tplContent;
		} else {
			echo <<<HTML
			<div class="tw-clothes-variations">
				<div class="sizes">
					<label>Taille</label>
					<select name="clothesVariationSize" id="clothesVariationSize">
						<option>S</option>
					</select>
				</div>
				<div class="colors">
					<label>Couleur</label>
					<ul>
						<li class="clothesVariationColorSelector">
							<span style="background-color:white;"></span>
							Blanc
						</li>
					</ul>
				</div>
			</div>
			HTML;
		}
	}
}