<?php if(count($args['categories']) > 1) { ?>
    <div class="productCategorySelector">
        <div class="header">
            <h3>
                <?php echo $args['currentCategoryName']; ?>
            </h3>
        </div>
        <div class="content" style="margin-top:10px;">
            <ul>
            <?php foreach($args['categories'] as $item) {
                if($item['name'] != $args['currentCategoryName']){ ?>
                    <li>
                        <a href="<?php echo $item['link'] ?>"><?php echo $item['name']; ?></a>
                    </li>
                <?php } 
            } ?>
            </ul>
        </div>
    </div>
<?php } ?>

<div class="productSearch">
    <div class="header">
        <h3>
            Affiner la recherche<br />
            <!--<span class="nbrProduct"><?php echo $args['nbrProducts']; ?> Produits</span>-->
        </h3>
    </div>
    <div class="content" style="margin-top:10px;">
        <div class="searchCriterias" style="display:none;">
            <h3>Critères de recherche</h3>
            <ul class="content">
            </ul>
        </div>

        <input type="hidden" name="pageUrl" value="<?php echo $args["pageUrl"] ?>" />
        <input type="hidden" name="ajaxUrl" value="<?php echo $args["ajaxUrl"] ?>" />
        <form method="GET" class="productSearchForm">
            <input type="hidden" name="s_productcat" value="<?php echo $args['productCategory']; ?>" />
            <div class="formRow">
                <label>Sexe</label>
                <select name="s_sex">
                    <option value=""><?php echo __("Tous", "twcommerce") ?></option>
                    <?php foreach($args['customTaxonomies']['pa_sex'] as $slug => $name) { ?>
                        <?php if(isset($args['params']['sex']) &&  $args['params']['sex'] == $slug) { ?>
                            <option selected="selected" value="<?php echo $slug; ?>"><?php echo $name; ?></option>
                        <?php } else { ?>
                            <option value="<?php echo $slug; ?>"><?php echo $name; ?></option>
                        <?php } ?>
                    <?php } ?>
                </select>
            </div>

            <div class="formRow">
                <label>Taille</label>
                <select name="s_size">
                    <option value=""><?php echo __("Toutes", "twcommerce") ?></option>
                    <?php foreach($args['customTaxonomies']['pa_size'] as $slug => $name) { ?>
                        <?php if(isset($args['params']['size']) && $args['params']['size'] == $slug) { ?>
                            <option selected="selected" value="<?php echo $slug; ?>"><?php echo $name; ?></option>
                        <?php } else { ?>
                            <option value="<?php echo $slug; ?>"><?php echo $name; ?></option>
                        <?php } ?>
                    <?php } ?>
                </select>
            </div>

            <div class="formRow">
                <label>Marque</label>
                <select name="s_brand">
                    <option value=""><?php echo __("Toutes", "twcommerce") ?></option>
                    <?php foreach($args['customAttributes']['_productattribute_brand'] as $name) { ?>
                        <?php if(isset($args['params']['brand']) && $args['params']['brand'] == $name) { ?>
                            <option selected="selected" value="<?php echo $name; ?>"><?php echo $name; ?></option>
                        <?php } else { ?>
                            <option value="<?php echo $name; ?>"><?php echo $name; ?></option>
                        <?php } ?>
                    <?php } ?>
                </select>
            </div>

            <div class="formRow priceFormRow">
                <label>Prix</label>

                <div id="productPriceSliderContainer" style="display:none;">
                    <input type="text" name="s_price" id="productPriceSlider" />
                    <div id="productPriceSliderDetail">
                        <label><span class="min">
                            <?php
                                if(isset($args['params']['priceMin'])){ 
                                    echo $args['params']['priceMin'];
                                } else {
                                    echo $args['min'];
                                }
                            ?>
                            </span> €</label>
                        <label> - </label>
                        <label><span class="max">
                            <?php
                                if(isset($args['params']['priceMax'])){ 
                                    echo $args['params']['priceMax'];
                                } else {
                                    echo $args['max'];
                                }
                            ?>
                        </span> €</label>
                    </div>
                </div>
            </div>

            <!--<button type="submit">Rechercher</button>-->
        </form>
    </div>
</div>

<script type="text/javascript">
    document.addEventListener("DOMContentLoaded", function(event) {
        let formIsSubmitting = false; 
        let searchCriterias = {};
        let initialParams = JSON.parse(<?php echo "'" . json_encode($args['params'], JSON_HEX_QUOT|JSON_HEX_APOS) . "'"; ?>);
        const min = <?php echo $args['min'] ?>;
        const max = <?php echo $args['max'] ?>;

        function submitForm()
        {   
            const form = document.querySelector('.productSearchForm');
            const currentUrl = window.location.href;

            let urlParser = new URL(currentUrl);
            let ajaxUrl = urlParser.origin + urlParser.pathname;
            let matches = ajaxUrl.match(/\/page\/(\d+)/);
            if(typeof(matches) != "undefined" && Array.isArray(matches) && matches.length == 2) {
                ajaxUrl = ajaxUrl.replace('page/' + matches[1] + '/', '');
            }

            let params = tw_serialize_form_data(new FormData(form));
            Object.keys(params).forEach((key, index) => {
                if(index < 1) {
                    ajaxUrl += '?' + key + '=' + encodeURIComponent(params[key]);
                } else {
                    ajaxUrl += '&' + key + '=' + encodeURIComponent(params[key]);
                }
            });

            formIsSubmitting = true;
            fetch(ajaxUrl, {
                method: "GET"
            }).then(function(resp){
                resp.text().then((htmlContent) => {
                    let parser = new DOMParser();
                    let parsedDoc = parser.parseFromString(htmlContent, "text/html");
                    let widgetContent = parsedDoc.querySelector('.productListColumn .productLoopGrid').innerHTML;
                    
                    document.querySelector('.productListColumn .productLoopGrid').innerHTML = widgetContent;
                    hasSubmittedForm = true;
                });

                history.replaceState(null, "", ajaxUrl);
                formIsSubmitting = false;
            });
        }

        function initSearchCriterias()
        { 
            if(typeof(initialParams['price']) != "undefined") {
                const selectedPriceMin = parseInt(initialParams['price'].split(',')[0]);
                const selectedPriceMax = parseInt(initialParams['price'].split(',')[1]);
                if(selectedPriceMin != min && selectedPriceMax != max) {
                    searchCriterias['price'] = {'type':'range', 'label':'Prix', 'key':'price', 'title':'price', 'min':selectedPriceMin, 'max':selectedPriceMax};
                }

                delete initialParams['priceMin'];
                delete initialParams['priceMax'];
                delete initialParams['price'];
            }

            Object.keys(initialParams).forEach((paramName) => {
                if(paramName != "productcat") {
                    const elem = document.querySelector('.productSearchForm [name="s_' + paramName + '"]');
                    let label = elem.closest('.formRow').querySelector('label').textContent;

                    searchCriterias[paramName] = {'key': paramName, 'label':label, 'title':paramName, 'value':initialParams[paramName]};
                }
            });
            renderSearchCriterias();
        }
        initSearchCriterias();

        function renderSearchCriterias()
        {
            let container = document.querySelector('.productSearch .searchCriterias ul');
            container.innerHTML = "";

            let criteriaKeys = Object.getOwnPropertyNames(searchCriterias);
            if(criteriaKeys.length < 1) {
                container.closest('.searchCriterias').style.display = "none";
            } else {
                container.closest('.searchCriterias').style.display = "block";
                Object.entries(searchCriterias).forEach((crit) => {
                    container.insertAdjacentHTML('beforeend', '<li>' + crit[1].label + '<span data-key="' + crit[1].key.replace('s_', '') + '" class="remove"><i class="fas fa-times fa-fw"></i></span></li>');
                });
            }

            document.querySelectorAll('.productSearch .searchCriterias .remove').forEach((item) => {
                item.removeEventListener('click', clearSearchCriterias);
                item.addEventListener('click', clearSearchCriterias);
            });
        }

        function clearSearchCriterias(event)
        {
            const criteriaKey = event.currentTarget.getAttribute('data-key');
            const criteriaValue = searchCriterias[criteriaKey];
            let criteriaElement = document.querySelector('.productSearch [name="s_' + criteriaKey + '"]');

            if(typeof(criteriaValue['type']) == "undefined" || criteriaValue['type'] != "range") {
                const tagName = criteriaElement.tagName;
                if(tagName == "SELECT") {
                    const firstOptionValue = criteriaElement.querySelectorAll('option')[0].value;
                    criteriaElement.value = firstOptionValue;
                } else {
                    criteriaElement.value = "";
                }

                delete searchCriterias[criteriaKey];
                renderSearchCriterias();
                criteriaElement.dispatchEvent(new Event('change'));
            } else {
                document.querySelector('#productPriceSlider').value = min + "," + max;
                productPriceSlider.setValues(min,max);

                document.querySelector('#productPriceSliderDetail .min').innerHTML = min;
                document.querySelector('#productPriceSliderDetail .max').innerHTML = max;

                delete searchCriterias[criteriaKey];
                renderSearchCriterias();
            }
        }

        document.querySelector('#productPriceSliderContainer').style.display = "block";

        let priceMin = min;
        <?php if(isset($args['params']['priceMin']) && !empty($args['params']['priceMin'])) { ?>
            priceMin = <?php echo $args['params']['priceMin'] ?>;
        <?php } ?>

        let priceMax = max;
        <?php if(isset($args['params']['priceMax']) && !empty($args['params']['priceMax'])) { ?>
            priceMax = <?php echo $args['params']['priceMax'] ?>;
        <?php } ?>

        //TODO probleme rangeslider recharge la page tout seul
        //http://local.boutiquerando.fr/categorie-produit/vetement/page/3/

        //TOOD réécrire proprement les urls a partir de leur base et des params dans le replacestate
        let productPriceSlider = new rSlider({
            target: '#productPriceSlider',
            values: {min: min, max: max},
            step:50,
            range: true,
            tooltip: false,
            scale: true,
            labels: false,
            set: [priceMin, priceMax],
            onChange: function(values, hasBeenManuallyAdjusted){     
                if(!hasBeenManuallyAdjusted) {
                    return;
                }
                
                const selectedPriceMin = parseInt(values.split(',')[0]);
                const selectedPriceMax = parseInt(values.split(',')[1]);

                document.querySelector('#productPriceSliderDetail .min').innerHTML = selectedPriceMin;
                document.querySelector('#productPriceSliderDetail .max').innerHTML = selectedPriceMax;

                const inputName = "price";
                if(typeof(searchCriterias[inputName]) != "undefined") {
                    delete searchCriterias[inputName];
                }

                if(selectedPriceMin != min || selectedPriceMax != max) {
                    searchCriterias[inputName] = {'type':'range', 'label':'Prix', 'key':inputName, 'title':inputName, 'min':selectedPriceMax, 'max':selectedPriceMax};
                }
                renderSearchCriterias();
                submitForm();
            }
        });

        document.querySelectorAll('.productSearchForm select').forEach((item) => {
            item.addEventListener('change', (e) => {
                const inputName = e.target.getAttribute('name');
                const inputKey = inputName.replace('s_', '');
                const inputLabel = e.target.closest('.formRow').querySelector('label').textContent;
                const inputValue = e.target.value;
                if(typeof(searchCriterias[inputKey]) != "undefined") {
                    delete searchCriterias[inputKey];
                }

                if(typeof(inputValue) != "undefined" && inputValue.trim() != "") {
                    searchCriterias[inputKey] = {'key': inputName, 'label': inputLabel, 'title':inputName, 'value': inputValue};
                }
                renderSearchCriterias();
                submitForm();
            })
        });

        document.querySelector('.productListColumn').addEventListener('click', (event) => {
            let target = event.srcElement;
            let isPaginationLink = false;

            
            if(typeof(target.closest('.elementor-pagination')) != "undefined" && target.closest('.elementor-pagination') !== null) {       
                let link = target.getAttribute('href');
                
                if(link !== null) {
                    fetch(link, {
                        method: "GET"
                    }).then(function(resp){
                        resp.text().then((htmlContent) => {
                            let parser = new DOMParser();
                            let parsedDoc = parser.parseFromString(htmlContent, "text/html");
                            let widgetContent = parsedDoc.querySelector('.productListColumn .productLoopGrid').innerHTML;

                            document.querySelector('.productListColumn .productLoopGrid').innerHTML = widgetContent;
                        });
                        history.replaceState(null, "", link);
                    });
                }

                event.preventDefault();
                event.stopPropagation();
                return false;
            }
        });
    });
</script>