<?php
class TW_WIDGET_CustomIcon extends \Elementor\Widget_Base {


	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);
	}

    protected function register_controls()
    {
        $this->start_controls_section(
			'section_settings',
			[
				'label' => esc_html__( 'Réglage', 'tw-theme' ),
			]
		);

        $this->add_control(
            'icon',
            [
                'label' => esc_html__( 'Icon', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__( "Classe css de l'icone", 'tw-theme' ),
                'label_block' => true,
                'dynamic' => [
                    'active' => false,
                ],
            ]
        );

        $this->add_control(
            'link',
            [
                'label' => esc_html__( 'Lien', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__( 'Lien', 'tw-theme' ),
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
					'url' => '',
				],
            ]
        );

        $this->end_controls_section();
    }

	protected function is_dynamic_content(): bool {
		return true;
	}

	public function get_name() {
		return 'tw_customicon';
	}

	public function get_title() {
		return esc_html__( 'Icones personalisés', 'tw-theme' );
	}

	public function get_icon() {
		return 'eicon-custom';
	}

	public function get_categories() {
		return [ 'theme-elements' ];
	}

	public function get_keywords() {
		return ['custom', 'icon'];
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
        $icon = isset($settings['icon']) ? $settings['icon'] : '';
        $link = isset($settings['link']) ? $settings['link']['url'] : '';

        $content = '<a href="' . $link . '">';
        $content .= '<i href="' . $link . '" class="' . $icon .  '"></i>';
        $content .= '</a>';
        echo $content;
	}
}