<?php
use Elementor\Includes\Elements\Container;

class TW_WIDGET_Container extends Container {

    protected function register_container_layout_controls()
    {
        parent::register_container_layout_controls();
        $registered = $this->add_control(
            'content_width',
            [
                'tab' => 'layout',
                'section' => 'section_layout_container',
				'label' => esc_html__( 'Content Width', 'elementor' ),
				'type' => 'select',
				'default' => 'boxed',
				'options' => [
					'boxed' => esc_html__('Boxed', 'elementor'),
                    'wide' => esc_html__('Grande largeur', 'twcommerce-theme'),
					'full' => esc_html__('Full Width', 'elementor')
				],
				'render_type' => 'template',
				'prefix_class' => 'e-con-',
				'editor_available' => true,
			],
            [
                'overwrite' => true
            ]
        );
    }
}