<?php

$shipping_summary_packages = WC()->shipping()->get_packages();
$chosen_shipping_methods = WC()->session->chosen_shipping_methods;
$selected_shipping_package = null;
$selected_shipping_rate = null;

if(count($shipping_summary_packages) > 1) {
    throw new Exception("Multiple package not supported");
} else if(!empty($chosen_shipping_methods) && trim($chosen_shipping_methods[0]) != ""){
   $selected_shipping_package = $shipping_summary_packages[0];
   $selected_shipping_rate = $shipping_summary_packages[0]['rates'][$chosen_shipping_methods[0]];
}
?>
<?php if($selected_shipping_rate !== null) { ?>
    <tr>
        <td>
            <div class="flex-row">
                <div>
                    <?php echo __("title.orderReviewDelivery", "tw-theme"); ?>
                    <span class="shipping_summary_method">
                        <?php echo $selected_shipping_rate->get_label(); ?>
                    <span class="shipping_summary_address">
                        <?php echo ucfirst(strtolower($selected_shipping_package['destination']['address'])); ?><br />
                        <?php echo ucfirst(strtolower($selected_shipping_package['destination']['city'])); ?>
                    </span>
                </div>
                <div>
                    <?php echo wc_price((float)$selected_shipping_rate->get_cost() + $selected_shipping_rate->get_shipping_tax()) ?>
                </div>
            </div>
        </td>
    </tr>
<?php } ?>