<?php
/**
 * Checkout shipping information form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-shipping.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 * @global WC_Checkout $checkout
 */

defined( 'ABSPATH' ) || exit;
?>
<div class="woocommerce-shipping-fields">
	<?php if ( true === WC()->cart->needs_shipping_address() ) : ?>

        <h3><?php echo __("title.shipping", "tw-theme"); ?></h3>
        <ul class="ship_to_different_address_container">
            <li>
                <input 
                    id="ship-to-different-address_no"
                    class="input-radio" 
                    type="radio"
                    name="ship_to_different_address" 
                    value="0" 
                    <?php checked($checkout->get_value('ship_to_different_address'), 0) ?>
                />
                <label for="ship-to-different-address_yes">L'adresse de réception est la même que l'adresse de facturation</label> 
            </li>
            <li>
                <input 
                    id="ship-to-different-address_yes"
                    class="input-radio" 
                    type="radio"
                    name="ship_to_different_address" 
                    value="1"
                    <?php checked($checkout->get_value('ship_to_different_address'), 1) ?>
                />
                <label for="ship-to-different-address_yes">L'adresse de réception n'est pas la même que l'adresse de facturation</label> 
            </li>
        </ul>

		<div <?php if(!$checkout->get_value('ship_to_different_address')){ ?>style="display:none;"<?php } ?> class="shipping_address">
			<?php do_action( 'woocommerce_before_checkout_shipping_form', $checkout ); ?>

			<div class="woocommerce-shipping-fields__field-wrapper">
				<?php
				$fields = $checkout->get_checkout_fields( 'shipping' );

				foreach ( $fields as $key => $field ) {
					woocommerce_form_field( $key, $field, $checkout->get_value( $key ) );
				}
				?>
			</div>

			<?php do_action( 'woocommerce_after_checkout_shipping_form', $checkout ); ?>
		</div>

	<?php endif; ?>
</div>

<table class="woocommerce-shipping-table">
    <tbody>
        <?php if (WC()->cart->needs_shipping() && WC()->cart->show_shipping() ) : ?>
            <?php do_action( 'woocommerce_review_order_before_shipping' ); ?>
            <?php wc_cart_totals_shipping_html(); ?>
            <?php do_action( 'woocommerce_review_order_after_shipping' ); ?>
        <?php endif; ?>
    </tbody>
</table>

<div style="display: flex; margin-bottom:10px;">
    <input type="checkbox" id="display-additional-fields" name="display-additional-fields" value="1"/>
    <label style="margin-left: 10px;" for="display-additional-fields"><?php esc_html_e( 'Additional information', 'woocommerce' ); ?></label>
</div>

<div style="display: none;" class="woocommerce-additional-fields">
	<?php do_action( 'woocommerce_before_order_notes', $checkout ); ?>

	<?php if ( apply_filters( 'woocommerce_enable_order_notes_field', 'yes' === get_option( 'woocommerce_enable_order_comments', 'yes' ) ) ) : ?>
		<div class="woocommerce-additional-fields__field-wrapper">
			<?php foreach ( $checkout->get_checkout_fields( 'order' ) as $key => $field ) : ?>
				<?php woocommerce_form_field( $key, $field, $checkout->get_value( $key ) ); ?>
			<?php endforeach; ?>
		</div>

	<?php endif; ?>

	<?php do_action( 'woocommerce_after_order_notes', $checkout ); ?>
</div>
