<?php
/**
 * Checkout billing information form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-billing.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 * @global WC_Checkout $checkout
 */

defined( 'ABSPATH' ) || exit;
$billing_fields = $checkout->get_checkout_fields('billing');

$coordinate_fields['billing_email'] = $billing_fields['billing_email'];
unset($billing_fields['billing_email']);

if(isset($billing_fields['billing_phone'])){
    $coordinate_fields['billing_phone'] = $billing_fields['billing_phone'];
    unset($billing_fields['billing_phone']);
}
?>

<div class="woocommerce-coordinate-fields">
	<h3><?php esc_html_e( 'title.coordinates', 'tw-theme' ); ?></h3>
    <div class="flex-row">
        <?php woocommerce_form_field('billing_email', $coordinate_fields['billing_email'], $checkout->get_value('billing_email')); ?>
        <?php if(isset($coordinate_fields['billing_phone'])) {
            woocommerce_form_field('billing_phone', $coordinate_fields['billing_phone'], $checkout->get_value('billing_phone'));
        } ?>
    </div>
</div>

<?php if (!is_user_logged_in() && $checkout->is_registration_enabled()) : ?>
	<div class="woocommerce-account-fields">
		<?php if ( ! $checkout->is_registration_required() ) : ?>

			<?php if($checkout->get_value( 'createaccount') == true || apply_filters( 'woocommerce_create_account_default_checked', false ) == true) { ?>
				<input type="hidden" id="createaccount" name="createaccount" value="1" />
			<?php } else { ?>
				<p class="form-row form-row-wide create-account">
					<label class="woocommerce-form__label woocommerce-form__label-for-checkbox checkbox">
						<input class="woocommerce-form__input woocommerce-form__input-checkbox input-checkbox" id="createaccount" <?php checked( ( true === $checkout->get_value( 'createaccount' ) || ( true === apply_filters( 'woocommerce_create_account_default_checked', false ) ) ), true ); ?> type="checkbox" name="createaccount" value="1" /> <span><?php esc_html_e( 'Create an account?', 'woocommerce' ); ?></span>
					</label>
				</p>
			<?php } ?>
		<?php endif; ?>

		<?php do_action( 'woocommerce_before_checkout_registration_form', $checkout ); ?>

		<?php if ( $checkout->get_checkout_fields( 'account' ) ) : ?>

			<div class="create-account">
				<?php foreach ( $checkout->get_checkout_fields( 'account' ) as $key => $field ) : ?>
					<?php woocommerce_form_field( $key, $field, $checkout->get_value( $key ) ); ?>
				<?php endforeach; ?>
				<div class="clear"></div>
			</div>

		<?php endif; ?>

		<?php do_action( 'woocommerce_after_checkout_registration_form', $checkout ); ?>
	</div>
<?php endif; ?>

<div class="woocommerce-billing-fields">
	<?php if ( wc_ship_to_billing_address_only() && WC()->cart->needs_shipping() ) : ?>

		<h3><?php esc_html_e( 'Billing &amp; Shipping', 'woocommerce' ); ?></h3>

	<?php else : ?>

		<h3><?php esc_html_e( 'Billing details', 'woocommerce' ); ?></h3>

	<?php endif; ?>

	<?php do_action( 'woocommerce_before_checkout_billing_form', $checkout ); ?>

	<div class="woocommerce-billing-fields__field-wrapper">
        <?php woocommerce_form_field('billing_country', $billing_fields['billing_country'], $checkout->get_value('billing_country')); ?>
        <?php woocommerce_form_field('billing_state', $billing_fields['billing_state'], $checkout->get_value('billing_state')); ?>

        <?php woocommerce_form_field('billing_first_name', $billing_fields['billing_first_name'], $checkout->get_value('billing_first_name')); ?>
        <?php woocommerce_form_field('billing_last_name', $billing_fields['billing_last_name'], $checkout->get_value('billing_last_name')); ?>
        <?php 
			if(!is_array($billing_fields['billing_company']['class'])){
				$billing_fields['billing_company']['class'] = [];
			}
			if(!in_array('form-row-wide', $billing_fields['billing_company']['class'])){
				$billing_fields['billing_company']['class'] = 'form-row-wide';
			}
			$billing_fields['billing_company']['label'] = __("Nom de l’entreprise", "tw-theme");
			woocommerce_form_field('billing_company', $billing_fields['billing_company'], $checkout->get_value('billing_company')); 
		?>

        <?php woocommerce_form_field('billing_address_1', $billing_fields['billing_address_1'], $checkout->get_value('billing_address_1')); ?>
        <?php woocommerce_form_field('billing_address_2', $billing_fields['billing_address_2'], $checkout->get_value('billing_address_2')); ?>

        <div class="flex-row">
            <?php woocommerce_form_field('billing_postcode', $billing_fields['billing_postcode'], $checkout->get_value('billing_postcode')); ?>
            <?php woocommerce_form_field('billing_city', $billing_fields['billing_city'], $checkout->get_value('billing_city')); ?>
        </div>

		<?php
        /*
		foreach ( $billing_fields as $key => $field ) {
			woocommerce_form_field( $key, $field, $checkout->get_value( $key ));
		}
        */
		?>
	</div>

	<?php do_action( 'woocommerce_after_checkout_billing_form', $checkout ); ?>
</div>
