<?php
/**
 * My Account page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/my-account.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.5.0
 */

defined( 'ABSPATH' ) || exit;

/**
 * My Account navigation.
 *
 * @since 2.6.0
 */
do_action( 'woocommerce_account_navigation' );
list($items, $endpoints) = tw_get_account_menu_items();
$url = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'] .  $_SERVER['REQUEST_URI'];

$title = null;
$key = array_search($url, $endpoints);
if($key !== false && isset($items[$key])) {
	$title = $items[$key];
}
?>

<div class="woocommerce-MyAccount-content">
	
<?php 
	if($title !== null) { ?>
	<div class="title_with_border">
		<h1 class="elementor-heading-title elementor-size-default"><?php echo $title; ?></h1>
	</div>
<?php } ?>
	<div style="margin-top:20px;"></div>
	<?php
		/**
		 * My Account content.
		 *
		 * @since 2.6.0
		 */
		do_action( 'woocommerce_account_content' );
	?>
</div>
