<?php
trait TW_Product_Repository_Variation_Trait {
    public function getVariationSize(WC_Product $product, $formatValue = true)
    {
        global $wpdb;

        if(!isset($this->_cache['variationSize'])) {
            $this->_cache['variationSize'] = [];
        }

        if(isset($this->_cache['variationSize'][$product->get_id()])){
            $res = $this->_cache['variationSize'][$product->get_id()];
            if($formatValue == false) {
                return $res;
            } else {
                $formattedValue = "";
                for($i=0;$i<count($res);$i++) {
                    if($i < count($res) - 1) {
                        $formattedValue .= strtoupper($res[$i]) . ' | ';
                    } else {
                        $formattedValue .= strtoupper($res[$i]);
                    }
                }
                return $formattedValue;
            }
        }

        $query = "
            select distinct(name)
            FROM
            (
                select wtr.object_id, wt.name
                from tw_variable_product tvp 
                left join wp_term_relationships wtr on (wtr.object_id = tvp.target_product_id)
                left join wp_term_taxonomy wtt on (wtt.term_taxonomy_id = wtr.term_taxonomy_id)
                left join wp_terms wt on (wt.term_id = wtt.term_id)
                where tvp.product_id = " . esc_sql($product->get_id()) . "
                and wtt.taxonomy  = 'pa_size'
                UNION 
                select wtr.object_id , wt.name
                from wp_term_relationships wtr
                left join wp_term_taxonomy wtt on (wtt.term_taxonomy_id = wtr.term_taxonomy_id)
                left join wp_terms wt on (wt.term_id = wtt.term_id)
                where wtr.object_id  = " . esc_sql($product->get_id()) . "
                and wtt.taxonomy = 'pa_size'
            ) as src
        ";

        $res = $wpdb->get_col($query);
        $this->_cache['variationSize'][$product->get_id()] = (is_array($res) && count($res) > 0) ? $res : [];

        if($formatValue == false) {
            return (is_array($res) && count($res) > 0) ? $res : [];
        } else {
            $formattedValue = "";
            for($i=0;$i<count($res);$i++) {
                if($i < count($res) - 1) {
                    $formattedValue .= strtoupper($res[$i]) . ' | ';
                } else {
                    $formattedValue .= strtoupper($res[$i]);
                }
            }
            return $formattedValue;
        }
    }
}