<?php
add_filter('gettext', function($translation, $text, $domain){
    if($domain == 'tw-theme') {
        $locale = get_locale();
        $translation_path = plugin_dir_path(dirname(__FILE__)) . 'translations/';
        $filename = $domain . '-fr.json';

        if(($locale == 'en_GB' || $locale == 'en_US') && file_exists($translation_path . $domain . '-en.json')) {
            $filename = $domain . '-en.json';
        }

        if(file_exists($translation_path . $filename)){
            $json = file_get_contents($translation_path . $filename);
            $json = @json_decode($json, true);

            if($json !== null && isset($json[$text])){
                return $json[$text];
            }
        }
    }
    return $translation;
}, PHP_INT_MAX, 3);