<?php

require_once ABSPATH .  PLUGINDIR . '/' . 'tw-core/classes/tw_wp_query.php';
require_once ABSPATH .  PLUGINDIR . '/' . 'tw-core/repository/product_repository.php';

function twcommerce_product_search($posts, WP_Query $query) {
    global $wp_rewrite;
    global $paged;

    $params = tw_parse_url($_SERVER['REQUEST_URI'])['params'];

    $matchedNumbers = [];
    if(preg_match('#page/(\d)#', $_SERVER['REQUEST_URI'], $matchedNumbers) !== false && count($matchedNumbers) == 2) {
        $pageNumber = $matchedNumbers[1];
        $params['page'] = $pageNumber;
    } else if(isset($params['paged'])){
        $params['page'] = $params['paged'];
        unset($params['paged']);
    }

    if(
        $query->get('wc_query') 
        || (isset($params['action']) && $params['action'] == 'ajax_product_search')
    ){
        $postPerPage = 9;

        foreach($params as $key => &$value) {
            $value = stripslashes($value);
        }

        $default_query_args = [
            'post_type' => 'product',
            'meta_query' => [
                [
                    'field' => '_stock_status',
                    'value' => ['instock','onbackorder']
                ]
            ],
            'tax_query' => [],
            'orderby' => ['wp.post_title' => 'ASC'],
            'posts_per_page' => $postPerPage,
            'offset' => 0
        ];

        $categoriesSlugs = [];
        if($query->get('product_cat') !== null && !empty($query->get('product_cat'))){
            $categories = TW_Factory::getInstance()->getClass(TW_Product_Repository::class)->getCategoriesSlugWithChild($query->get('product_cat'));
            foreach($categories as $item) {
                $categoriesSlugs[] = $item['slug'];
            }
        } else if(isset($params['s_product_cat']) && !empty($params['s_product_cat'])){
            $categories = TW_Factory::getInstance()->getClass(TW_Product_Repository::class)->getCategoriesSlugWithChild($params['s_product_cat']);
            foreach($categories as $item) {
                $categoriesSlugs[] = $item['slug'];
            }
        }

        if(!empty($categoriesSlugs)){
            $default_query_args['tax_query'][] = [
                'alias' => 'category',
                'taxonomy' => 'product_cat',
                'field' => 'slug',
                'terms' => $categoriesSlugs
            ];
        }

        if(!isset($params['page'])){
            $params['page'] = $query->get('paged') !== null ? (int)$query->get('paged') : 1;
        } else {
            $params['page'] = (int)$params['page'];
        }

        if(isset($params['page'])){
            $page = $params['page'] - 1;
            if($page < 0) {
                $page = 0;
            }
            $default_query_args['offset'] = $page * $postPerPage;
        }

        $priceMin = null;
        $priceMax = null;
        if(isset($params['s_price']) && strchr($params['s_price'], ',') !== false){
            $params['s_priceMin'] = explode(',', $params['s_price'])[0];
            $params['s_priceMax'] = explode(',', $params['s_price'])[1];
        }
        if(isset($params['s_priceMin']) && filter_var($params['s_priceMin'], FILTER_VALIDATE_FLOAT) !== false) {
            $priceMin = floatval($params['s_priceMin']);
        }
        if(isset($params['s_priceMax']) && filter_var($params['s_priceMax'], FILTER_VALIDATE_FLOAT) !== false) {
            $priceMax = floatval($params['s_priceMax']);
        }

        if(isset($params['s_name']) && !empty($params['s_name'])){
            $default_query_args['s'] = $params['s_name'];
        }
        
        if(isset($params['s_sex']) && !empty($params['s_sex'])){
            $default_query_args['tax_query'][] = [
                'alias' => 'sex',
                'taxonomy' => 'pa_sex',
                'field' => 'slug',
                'terms' => $params['s_sex']
            ];
        }
        if(isset($params['s_size']) && !empty($params['s_size'])){
            $default_query_args['tax_query'][] = [
                'alias' => 'size',
                'taxonomy' => 'pa_size',
                'field' => 'slug',
                'terms' => $params['s_size']
            ];
        }

        if(isset($params['s_brand']) && !empty($params['s_brand'])){
            $default_query_args['meta_query'][] = [
                'alias' => 'brand',
                'field' => '_productattribute_brand',
                'value' => $params['s_brand'],
                'operator' => 'LIKE'
            ];
        }
        
        if($priceMin !== null && $priceMax !== null) {
            $default_query_args['meta_query'][] = [
                'alias' => 'price',
                'field' => '_regular_price',
                'value' => $priceMin,
                'type' => 'numeric',
                'operator' => '>='
            ];
            $default_query_args['meta_query'][] = [
                'alias' => 'price',
                'field' => '_regular_price',
                'value' => $priceMax,
                'type' => 'numeric',
                'operator' => '<='
            ];
        }

        $default_query_args['tax_query'][] = [
            'alias' => 'color',
            'taxonomy' => 'pa_color',
            'operator' => 'NOP'
        ];

        $default_query_args['groupby'] = [
            'wp.post_title',
            'tq_color_term.slug'
        ];

        $tw_query = new TW_WP_Query($default_query_args);
        $tw_query->hydrateWpQuery($query);
        $posts = $query->posts;
    }
    return $posts;
}
add_filter('posts_pre_query', 'twcommerce_product_search', PHP_INT_MAX, 2);