<?php
add_filter('woocommerce_breadcrumb_defaults', function($params){    
    $params['delimiter'] = ' | ';
    unset($params['home']);

    return $params;
}, PHP_INT_MAX);



add_filter('woocommerce_get_breadcrumb', function($crumbs, WC_Breadcrumb $breadcrumb) {
    foreach($crumbs as $key => &$item) {
        if($item[0] == 'myaccount') {
            $item[0] = ucwords(strtolower('mon compte'));
        }
    }

    return $crumbs;
}, PHP_INT_MAX, 2);

add_filter('woocommerce_locate_template', function($template, $template_name, $template_path){
    if($template_name == 'global/breadcrumb.php') {
        $template = dirname(__DIR__) . '/templates/woocommerce_breadcrumb.php';
    }

    return $template;
}, PHP_INT_MAX, 3);