<?php

tw_include_files(__DIR__ . '/repository');
TW_Factory::getInstance()->instantiateClass(
    TW_Product_Repository::class,
    [
        TW_Product_Repository_Variation_Trait::class
    ]
);

tw_include_files(__DIR__ . '/includes');

add_filter('hello_elementor_page_title', function($shoudDisplayPageTitle){
    return false;
});

/*
* help to debug certain issues
function remove_css_js_version( $src ) {
    if( strpos( $src, '?ver=' ) ) {
        $src = remove_query_arg( 'ver', $src );
		$src = add_query_arg(array('ver' => rand(1,9999)), $src);
	}
    return $src;
}
add_filter( 'script_loader_src', 'remove_css_js_version', PHP_INT_MAX);
add_filter( 'style_loader_src', 'remove_css_js_version', 9999 );
*/

/**
 * class-wc-checkout
 * wc-frontend-scripts.php::init
 * add_action(wp_enqueue_scripts, load_scripts)
 *  
 * soit override du js
 * soit création d'un script en plus qui viendrait rajouter
 * des choses à l'existant
 * rajout d'un évènement load pour mettre la checkbox au bon endroit au bon moment
 * 
 * woocommerce_gateway_icon ne pas retour une image mais un span pour éviter au js de remplacer l'image
 */
add_filter('woocommerce_get_asset_url', function($file, $path){
    if(strchr($path, 'frontend/checkout.js')) {
        $file = get_site_url() . '/wp-content/themes/tw-theme/assets/js/checkout.js';
    } else if(strchr($path, 'frontend/address-i18n')) {
        $file = get_site_url() . '/wp-content/themes/tw-theme/assets/js/address-i18n.js';
    }

    return $file;
}, PHP_INT_MAX, 2);

add_filter('woocommerce_gateway_icon', function($icon, $id){
    return '<img class="payment-methods--logos" src="" />';
}, PHP_INT_MAX, 2);


//custom templates
add_filter('wc_get_template', function($template, $template_name, $args, $template_path, $default_path){
    if($template_name == 'cart/mini-cart.php') {
        return __DIR__ . '/templates/mini-cart.php';
    } else if($template_name == 'checkout/form-checkout.php') {
        return __DIR__ . '/templates/form-checkout.php';
    } else if($template_name == 'checkout/form-shipping.php') {
        return __DIR__ . '/templates/form-shipping.php';
    } else if($template_name == 'checkout/form-billing.php') {
        return __DIR__ . '/templates/form-billing.php';
    } else if($template_name == 'checkout/review-order.php') {
        return __DIR__ . '/templates/review-order.php';
    } else if($template_name == 'cart/cart-shipping.php') {
        return __DIR__ . '/templates/cart-shipping.php';
    } else if($template_name == 'summary/summary-shipping.php') {
        return __DIR__ . '/templates/summary-shipping.php';
    } else if($template_name == 'order/order-details.php') {
        return __DIR__ . '/templates/order-details.php';
    } else if($template_name == 'order/order-details-item.php') {
        return __DIR__ . '/templates/checkout-processed-order-details-item.php';
    } else if($template_name == 'myaccount/form-login.php') {
        return __DIR__ . '/templates/account-login.php';
    } else if($template_name == 'myaccount/lost-password-confirmation.php') {
        return __DIR__ . '/templates/account-lostpasswordconfirmation.php';
    } else if($template_name == 'myaccount/form-reset-password.php') {
        return __DIR__ . '/templates/account-resetpassword.php';
    } else if($template_name == 'myaccount/form-lost-password.php') {
        return __DIR__ . '/templates/account-lostpassword.php';
    } else if($template_name == 'myaccount/navigation.php') {
        return __DIR__ . '/templates/account-navigation.php';
    } else if($template_name == 'myaccount/my-account.php') {
        return __DIR__ . '/templates/account-mainview.php';
    } else if($template_name == 'myaccount/orders.php') {
        return __DIR__ . '/templates/account-orders.php';
    } else if($template_name == 'myaccount/my-address.php') {
        return __DIR__ . '/templates/my-address.php';
    }

    return $template;
}, PHP_INT_MAX, 5);

add_action('woocommerce_before_template_part', function($template_name, $template_path, $located, $args){
    
}, PHP_INT_MAX, 4);

/**
 * problèmes navigation privée vs non navigation privée http://local.boutiquerando2.fr/checkout/order-received/1440/?key=wc_order_etZH1OzWLBqpS
 * à vérifier
 * 
 * http://local.boutiquerando2.fr/checkout/order-received/1440/?key=wc_order_etZH1OzWLBqpS
 * http://local.boutiquerando2.fr/checkout/order-received/1440/?key=wc_order_etZH1OzWLBqpS
 * 
 * $total_rows['shipping']['label'] = 'test<br /><span class="detail">BELLA</span><br />';
 * 
 * $total_rows['shipping'] = [
	'label' => "Expédition :",
	'value' => "<span class="woocommerce-Price-amount amount"><bdi>50,00&nbsp;<span class="woocommerce-Price-currencySymbol">&euro;</span></bdi></span>&nbsp;<small class="shipped_via">via UPS</small>"	
]
 */

add_filter('woocommerce_get_order_item_totals', function($total_rows, $wc_order, $tax_display){
    $description = null;

    $selected_shipping_method = $wc_order->get_shipping_method();
    $available_shipping_methods = $wc_order->get_shipping_methods();

    foreach($available_shipping_methods as $shippingMethod) {
        if(trim(strtolower($shippingMethod->get_name())) == trim($selected_shipping_method)){

        }
    }

    $shipping_method = $wc_order->get_shipping_method();
    $methods = $wc_order->get_shipping_methods();

    return $total_rows;
}, PHP_INT_MAX, 3);

/*
add_action woocommerce_checkout_update_order_review
add_action woocommerce_before_checkout_form
*/
function tw_custom_checkout_form_input($field, $key, $args, $value)
{
    if(
        (strchr($key, 'billing') !== false 
            || strchr($key, 'shipping') !== false
            || strchr($key, 'order') !== false
        )
        && !in_array($args['type'], array('radio', 'hidden'))
    ) {
        $document = new DOMDocument();
        $documentLoaded = tw_execute_code_within_error_hander(function() use ($document, $field){
            return $document->loadHTML('<?xml encoding="utf-8" ?>' . $field, LIBXML_NOWARNING);
        });

        if($documentLoaded) {
            $xpath = new DOMXPath($document);
            $container = tw_single_item_or_null($xpath->query('//span[contains(@class, "woocommerce-input-wrapper")]'));
            $label = tw_single_item_or_null($xpath->query('//label'));

            if($container !== null && $label !== null) {
                $newLabel = $label->cloneNode(true);
                $container->insertBefore($newLabel, $container->firstChild);
                $label->parentNode->removeChild($label);

                return $document->saveHTML();
            }
        }
    }
    return $field;
}
add_action('woocommerce_checkout_update_order_review', function(){
    add_filter('woocommerce_form_field', 'tw_custom_checkout_form_input', PHP_INT_MAX, 4);
}, PHP_INT_MAX);
add_action('woocommerce_before_checkout_form', function(){
    add_filter('woocommerce_form_field', 'tw_custom_checkout_form_input', PHP_INT_MAX, 4);
}, PHP_INT_MAX);

add_filter('woocommerce_update_order_review_fragments', function($content){
    $orderReviewExpired = false;
    if ( WC()->cart->is_empty() && ! is_customize_preview() && apply_filters( 'woocommerce_checkout_update_order_review_expired', true ) ) {
        $orderReviewExpired = true;
    }

    if($orderReviewExpired === false) {
        ob_start();
        wc_cart_totals_shipping_html();
        $tw_cart_shipping_html = ob_get_contents();
        ob_end_clean();

        ob_start();
        wc_get_template('summary/summary-shipping.php');
        $tw_summary_shipping = ob_get_contents();
        ob_end_clean();

        $content['tw_cart_shipping_html'] = $tw_cart_shipping_html;
        $content['tw_summary_shipping'] = $tw_summary_shipping;
    }

    return $content;
}, PHP_INT_MAX, 1);

/*
add_action('init', function(){
    tw_custom_url(
        '^connexion-client$',
        []
    );
});
*/

add_filter('the_content', function($content){
    global $wp_query;
    if($wp_query->post !== null && $wp_query->post->post_name == "checkout") {
        $content = tw_render_template(__DIR__ . '/templates/page-checkout.php');
    } else if($wp_query->get('tw_custom_url') !== null && $wp_query->get('tw_custom_url') == 'connexion-client') {
        //$content = tw_render_template(__DIR__ . '/templates/page-customer-login.php');
    }

    return $content;
}, PHP_INT_MAX);

add_filter('default_checkout_ship_to_different_address', function($value, $input){
    $value = 0;

    if(isset($_POST['ship_to_different_address'])) {
        $value = (int)$_POST['ship_to_different_address'];
    } else {
        $optionValue = get_option( 'woocommerce_ship_to_destination');
        if(!empty($optionValue) && trim($optionValue) != 'billing') {
            $value = 1;
        }
    }
    return $value;
}, PHP_INT_MAX, 2);

//custom menu
add_filter('elementor/widget/tw_widget_mega_menu/init', function($data){
    $productCategories =  TW_Factory::getInstance()->getClass(TW_Product_Repository::class)->getProductCategories(['vetement', 'uncategorized'], false);

    $existingCategorieNames = [];
    foreach($data['settings']['menu_items'] as $item) {
        $existingCategorieNames[] = $item['item_title'];
    }

    foreach($productCategories as $item) {
        if(!in_array($item['name'], $existingCategorieNames)){
            $data['settings']['menu_items'][] = [
                '_id' => tw_generate_random_hex(),
                'item_title' => $item['name'],
                'item_link' => [
                    'url' => get_term_link((int)$item['term_id'], 'product_cat'),
                    'is_external' => '',
                    'nofollow' => '',
                    'custom_attributes' => ''
                ]
            ];

            $data['elements'][] = [
                'id' => tw_generate_random_hex(),
                'elType' => 'container',
                'settings' => [
                    '_title' => $item['name']
                ],
                'elements' => [],
                'isInner' => true,
                'isLocked' => true
            ];
        }
    }

    return $data;
});


//custom tag
function register_tw_tags( $dynamic_tags_manager ) {
    $dynamic_tags_manager->register( new TW_Elementor_Tag_Brand_Slide_Url());
    $dynamic_tags_manager->register( new TW_Elementor_Tag_Site_Account_Url());
}
add_action( 'elementor/dynamic_tags/register', 'register_tw_tags' );


add_action('wp_enqueue_scripts', 'theme_enqueue_styles', 10);
function theme_enqueue_styles() {
    $styleBaseUrl = get_site_url() . '/wp-content/themes/tw-theme/';

    tw_enqueue_style('twtheme_customicon', $styleBaseUrl . '/assets/css/flaticon.css', [], false);
    tw_enqueue_style('twtheme_fontawesome', $styleBaseUrl . '/assets/css/fontawesome.min.css', [], false);
    tw_enqueue_style('parent-style', $styleBaseUrl . 'style.css', ['hello-elementor']);
    tw_enqueue_style('custom-style', $styleBaseUrl . 'custom.css');

    if(!is_admin()){
        tw_enqueue_script('front', $styleBaseUrl . 'front.js');
    }
}

add_action('elementor/init', function(){
    if(\Elementor\Plugin::$instance->experiments->is_feature_active('e_element_cache')){
        update_option('elementor_experiment-e_element_cache', 'inactive');
        \Elementor\Plugin::$instance->files_manager->clear_cache();
    }
});

/*
add_filter( 'use_block_editor_for_post', function($use_block_editor, $post){
    return false;
}, 10, 2 );
*/