let tw_timeouts = {};

function tw_serialize_form_data(data) {
	let obj = {};
	for (let [key, value] of data) {
		if (obj[key] !== undefined) {
			if (!Array.isArray(obj[key])) {
				obj[key] = [obj[key]];
			}
			obj[key].push(value);
		} else {
			obj[key] = value;
		}
	}
	return obj;
}

function tw_display_notices(noticeTypesToDisplay = [])
{
	fetch(
		'/wp-admin/admin-ajax.php?action=tw_wc_ajax_notices'
	).then(function(res){
		res.json().then(function(jsonContent){
			const wrapper = document.querySelector('.woocommerce-notices-wrapper');
			wrapper.innerHTML = '';

			if(typeof(jsonContent['success']) != "undefined") {
				if(noticeTypesToDisplay.length < 1 || noticeTypesToDisplay.length > 0 && noticeTypesToDisplay.indexOf('success') != -1) {
					for(let i=0; i<jsonContent['success'].length; i++) {
						let item = jsonContent['success'][i];
						let noticeElem = '<div class="woocommerce-message">' + item['notice'] + '</div>';
	
						wrapper.insertAdjacentHTML('beforeend', noticeElem);
					}
				}
			}

			if(typeof(jsonContent['error']) != "undefined") {
				if(noticeTypesToDisplay.length < 1 || noticeTypesToDisplay.length > 0 && noticeTypesToDisplay.indexOf('error') != -1) {
					for(let i=0; i<jsonContent['error'].length; i++) {
						let item = jsonContent['error'][i];
						let noticeElem = '<div class="woocommerce-error">' + item['notice'] + '</div>';

						wrapper.insertAdjacentHTML('beforeend', noticeElem);
						if(typeof(tw_timeouts['notices']) != "undefined"){
							clearTimeout(tw_timeouts['notices']);
						}
						tw_timeouts['notices'] = setTimeout(() => {
							document.querySelectorAll('.woocommerce-message').forEach(function(item){
								item.remove();
							});
						}, 3000);
					}
				}
			}
		});
	})
}

function tw_update_cart_quantity()
{

	let refreshFragementUrl = wc_cart_fragments_params.wc_ajax_url.toString().replace( '%%endpoint%%', 'get_refreshed_fragments');
	let refreshFragementsData = new FormData();
	refreshFragementsData.append('time', new Date().getTime());

	fetch(
		refreshFragementUrl,
		{
			method: 'POST',
			body: refreshFragementsData
		}
	).then(function(resp2){
		resp2.json().then(function(jsonContent2){
			if(jsonContent2 && jsonContent2.fragments) {
				let fragmentKeysToRefresh = Object.keys(jsonContent2['fragments']);
				fragmentKeysToRefresh.forEach(function(key){
					document.querySelectorAll(key).forEach(function(item){
						item.outerHTML = jsonContent2['fragments'][key];
					});
				});

				sessionStorage.setItem( wc_cart_fragments_params.fragment_name, JSON.stringify(jsonContent2.fragments));
				localStorage.setItem( wc_cart_fragments_params.cart_hash_key, jsonContent2.cart_hash);
				sessionStorage.setItem( wc_cart_fragments_params.cart_hash_key, jsonContent2.cart_hash);

				if ( jsonContent2.cart_hash ) {
					window.sessionStorage.setItem( 'wc_cart_created', ( new Date() ).getTime() );
				}

				document.querySelector('body').dispatchEvent(new CustomEvent('wc_fragments_refreshed'));
			}
		});
	});
}

document.addEventListener('DOMContentLoaded', function(){
	let isCheckoutPage = false;
	if(document.querySelector('body').classList.contains('woocommerce-checkout')){
		isCheckoutPage = true;
	}

	//custom jquery event can only be catched with jquery
	jQuery('body').on('removed_from_cart', function(e, data){
		if(isCheckoutPage == true) {
			window.location.reload();
		}
	});

	document.addEventListener('click', function(e){
		if(e.target !== null 
			&& (e.target.closest('.cart-increase-quantity') !== null || e.target.closest('.cart-decrease-quantity') !== null)
		){
			let picker = e.target.closest('.product-quantity-picker');
			const cartItemKey = picker.getAttribute('data-cart-item-key');
			const quantity = picker.querySelector('input[type="number"]').value;

			let newQuantity = parseInt(quantity);
			if(e.target.closest('.cart-increase-quantity') !== null) {
				newQuantity = newQuantity + 1;
			} else if(e.target.closest('.cart-decrease-quantity') !== null) {
				if(newQuantity -1 >= 1) {
					newQuantity = newQuantity - 1;
				}
			}

			let params = new FormData();
			params.append('cart_item_key', cartItemKey);
			params.append('quantity', newQuantity);

			fetch(
				'/wp-admin/admin-ajax.php?action=update_product_cart_quantity',
				{
					method: 'POST',
					body: params
				}
			).then(function(resp){
				tw_update_cart_quantity();
				if(isCheckoutPage == true) {
					window.location.reload();
				}
			})
		}
	});

	let addToCartButton = document.querySelector('.single_add_to_cart_button');
	if(addToCartButton !== null) {
		addToCartButton.addEventListener('click', function(e){
			e.preventDefault();
			e.stopPropagation();

			let form = addToCartButton.closest('form');
			let formData = new FormData(form);			
			formData.append('add-to-cart', addToCartButton.getAttribute('value'));
			formData.append('add-to-cart-method', 'tw-ajax-add-to-cart');

			fetch(
				form.action,
				{
					method: 'POST',
					body: formData
				}
			).then(function(resp){
				tw_display_notices(['error']);
				tw_update_cart_quantity();
			});
			return false;
		});
	}

	//show popup
    let menuIcon = document.querySelector('.menuIcon');
    if(menuIcon !== null) {
        menuIcon.addEventListener('click', function(){
            elementorProFrontend.modules.popup.showPopup({ id: 298});
        });
    }
});