<?php
if(!defined('ABSPATH')){
    die;
}

//ln -s ../../tw_theme_variables.php tw_theme_variables.php
$GLOBALS['tw_post_types'] = [
    'brand' => [
        'locked' => true,
        'rewrite' => [
            'slug' => 'marques'
        ],
        'labels' => [
            'name' => __('Marques', 'tw'),
            'singular_name' => __('Marque', 'tw')
        ],
        'show_in_rest' => true,
        'public' => true,
        'show_ui' => true,
        'has_archive' => true,
        'menu_position' => 2,
        'menu_icon' => 'dashicons-portfolio',
        'supports' => [
            'title'
        ],
    ],
    'portfolio' => [
        'locked' => true,
        'rewrite' => [
            'slug' => 'portfolio'
        ],
        'labels' => [
            'name' => __('Portfolios', 'tw'),
            'singular_name' => __('Portfolio', 'tw')
        ],
        'public' => true,
        'show_ui' => true,
        'has_archive' => true,
        'menu_position' => 2,
        'menu_icon' => 'dashicons-portfolio',
        'supports' => [
            'title',
            'editor'
        ],
        'taxonomies' => [
            'technology'
        ]
    ]
];

$GLOBALS['tw_taxonomies'] = [
    'post___portfolio' => [
        'technology' => [
            'labels' => [
                'name' => __('Technologies', 'tw'),
                'singular_name' => __('Technology', 'tw')
            ],
            'description' => __('Technology', 'tw'),
            'hierarchical' => false,
            'show_in_menu' => false,
            'show_in_quick_edit' => false,
            'show_in_nav_menus' => false,
            'term_to_insert' => []
        ],
        'caca' => [
            'labels' => [
                'name' => __('caca', 'tw'),
                'singular_name' => __('caca', 'tw')
            ],
            'description' => __('caca', 'tw'),
            'show_in_menu' => false,
            'show_in_quick_edit' => false,
            'show_tagcloud' => false,
            'show_in_nav_menus' => false,
            'hierarchical' => false,
            //'show_ui' => false,
            'meta_box_cb' => false,
            'term_to_insert' => []
        ]
    ]
];

/**
 * value callback permet de définir la valeur
 * dans metabox_field multiple pour les types pdf et images si on veut en mettre plusieurs il faut bien préciser multiple
 * dans tw_metaboxes il est possible de spécifier des métas enregistrés ultérieurement via le filtre tw_metas
 * 
 * LE FILTRE tw_metas permet de rajouter des metas
 * LE FILTRE tw_metas_field permet de modifier le rendu d'un champ de meta
 * LE FILTRE tw_metas_save si valeur false permet de ne pas appliquer la valeur d'enregistrement de la meta
 */
$GLOBALS['tw_metas'] = [
    'post___brand' => [
        'tw_brand_icon' => [
            'single' => true,
            'type' => 'number',
            'value_default' => 0,
            'metabox_field' => [
                'display_name' => 'Icône',
                'field_type' => 'image',
            ]
        ],
        'tw_brand_slide_image' => [
            'single' => true,
            'type' => 'number',
            'value_default' => 0,
            'metabox_field' => [
                'display_name' => 'Image',
                'field_type' => 'image',
            ]
        ],
        'tw_brand_slide_title' => [
            'single' => true,
            'type' => 'string',
            'value_default' => '',
            'metabox_field' => [
                'display_name' => 'Titre',
                'field_type' => 'text',
            ]
        ],
        'tw_brand_slide_description' => [
            'single' => true,
            'type' => 'string',
            'value_default' => '',
            'metabox_field' => [
                'display_name' => 'Description',
                'field_type' => 'wysiwyg',
            ]
        ]
    ],
    'post___portfolio' => [
        'tw_portfolio_pdf' => [
            'single' => true,
            'type' => 'number',
            'metabox_field' => [
                'display_name' => 'Pdf',
                'field_type' => 'pdf',
                'multiple' => true
            ]
        ],
        'tw_portfolio_date' => [
            'single' => true,
            'type' => 'string',
            'metabox_field' => [
                'display_name' => 'Date',
                'description' => 'Date du portfolio',
                'field_type' => 'date'
            ]
        ],
        'tw_portfolio_order' => [
            'single' => true,
            'type' => 'number',
            'value_default' => 0,
            'metabox_field' => [
                'display_name' => 'Ordre',
                'field_type' => 'number'
            ]
        ],
        'tw_portfolio_icon' => [
            'single' => true,
            'type' => 'number',
            'value_default' => 0,
            'metabox_field' => [
                'display_name' => 'Icône',
                'field_type' => 'image',
            ]
        ],
        'tw_portfolio_image' => [
            'single' => false,
            'type' => 'number',
            'value_default' => 0,
            'metabox_field' => [
                'display_name' => 'Image',
                'field_type' => 'image',
                'multiple' => true
            ]
        ],
        'tw_portfolio_url_link' => [
            'single' => true,
            'type' => 'string',
            'value_default' => "",
            'metabox_field' => [
                'display_name' => 'Lien',
                'field_type' => 'text'
            ]
        ]
    ]
];

/**
 * il est possible d'afficher certaine metabox de manière conditionnel
 * en précisant la propriété visibility callback
 */
$GLOBALS['tw_metaboxes'] = [
    'post___brand' => [
        'tw_brand_general' => [
            'title' => __("General", "tw"),
            'fields' => [
                'tw_brand_icon'
            ]
        ],
        'tw_brand_slide' => [
            'title' => __("Slide accueil", "tw"),
            'fields' => [
                'tw_brand_slide_title',
                'tw_brand_slide_description',
                'tw_brand_slide_image'
            ]
        ],
    ],
    'post___portfolio' => [
        'tw_portfolio_pdf' => [
            'title' => __("Document", "tw"),
            'fields' => [
                tw_metabox_row(
                    'tw_portfolio_date',
                    'tw_portfolio_pdf'
                )
            ]
        ],
        'tw_portfolio_order' => [
            'title' => __("Ordre", "tw"),
            'fields' => [
                'tw_portfolio_order'
            ]
        ],
        'tw_portfolio_icon' => [
            'title' => __("Icône", "tw"),
            'fields' => [
                'tw_portfolio_icon'
            ]
        ],
        'tw_portfolio_gallery' => [
            'title' => __("Gallerie", "tw"),
            'fields' => [
                'tw_portfolio_image'
            ]
        ],
        'tw_portfolio_url' => [
            'title' => __("Lien", "tw"),
            'fields' => [
                'tw_portfolio_url_link'
            ]
        ]
    ]
];

//todo modifier tw validation pour ne faire plus qu'un tableau
$GLOBALS['tw_metabox_validation'] = [
    "post___portfolio" => [
        "post_title" => [
            [
                'type' => 'required',
                'message' => __('Ce champ est obligatoire', 'tw')
            ]
        ],
        "tax_input[technology]" => [
            [
                'type' => 'required',
                'message' => __('Ce champ est obligatoire', 'tw')
            ]
        ]
    ]
];

$GLOBALS['tw_computed_properties'] = [
    'post___product' => [
        'variation_size' => [
            'repository' => TW_Product_Repository::class,
            'method' => 'getVariationSize'
        ]
    ]
];


//e-commerce
$GLOBALS['tw_product_default_taxonomy'] = [
	'sex', 
	'color', 
	'size'
];

$GLOBALS['tw_product_default_attributes'] = [
    'dimensions' => array(
		'label' => __( 'Dimensions', 'tw_commerce'),
		'value' => '',
		'position' => 0,
		'is_visible' => 0,
		'is_variation' => 0,
		'is_taxonomy' => 0
	),
	'brand' => array(
		'label' => __( 'Marque', 'tw_commerce'),
		'value' => '',
		'position' => 0,
		'is_visible' => 0,
		'is_variation' => 0,
		'is_taxonomy' => 0
	),
	'materials_and_technologies' => array(
		'label' => __( 'Matériaux et technologies', 'tw_commerce'),
		'value' => '',
		'position' => 0,
		'is_visible' => 0,
		'is_variation' => 0,
		'is_taxonomy' => 0
	)
];

//TODO A MODIFIER IL FAUT TOUJOURS L INCURE
$GLOBALS['tw_supplier_informations'] = [
    'supplier_name' => [
        'label' => __( 'Supplier name', 'tw_commerce'),
        'description' => '',
        'type' => 'text'
    ],
    'restocking_delay' => [
        'label' => __( 'Restocking delay', 'tw_commerce'),
        'description' => '',
        'type' => 'text'
    ],
    'manage_restocking' => [
        'label' => __( 'Manage restocking', 'tw_commerce'),
        'description' => '',
        'type' => 'checkbox'
    ],
    'supplier_restocking_url' => [
        'label' => __( 'Restocking url', 'tw_commerce'),
        'description' => '',
        'type' => 'text'
    ]
];