<?php

define('WP_ADMIN', true);
define('WP_USE_THEMES', false);
require_once dirname(__DIR__, 2) . '/wp-load.php';

$authorized = false;

if(!isset($_GET['expeditionId']) && !isset($_GET['expeditionType'])){
    header('HTTP/1.0 401 Unauthorized');
    die;
}

$expeditionId = $_GET['expeditionId'];
$expeditionType = $_GET['expeditionType'];

$shippingRepository = TW_Factory::getInstance()->getClass(TW_Shipping_Repository::class);
$shipping = $shippingRepository->getShippingByShippingId($expeditionId);
$shippingDetails = [];

if($shipping !== null) {
    $shippingDetails = $shippingRepository->getShippingDetailsByShippingId($expeditionId);
}

if($shipping !== null 
    && !empty($shippingDetails) 
    && isset($_GET['nonce']) 
    && wp_verify_nonce($_GET['nonce'], 'twpdflabel' . $expeditionType . '_' . $expeditionId . '_' . $shipping->order_id)) {
    $authorized = true;
}

if(!$authorized) {
    header('HTTP/1.0 401 Unauthorized');
    die;
}

$adminUserId = null;
$adminUsers = get_users(['capability__in' => 'administrator']);
if(!empty($adminUsers)){
    $adminUserId = $adminUsers[0]->ID;
}
wp_set_current_user($adminUserId);

$shippingHandler = TW_Shipping_Manager::getInstance()->getHandler($shipping, $shippingDetails);
$shippingHandler->generatePdf($shipping, $shippingDetails, 'I');
die;