<?php
if(!defined('ABSPATH')){
    die;
}

class TW_Shipping_Colissimo_Handler extends TW_Shipping_Handler {

    public function canHandle(TW_Shipping $shipping)
    {
        if(strchr($shipping->carrier, 'lpc_') !== false) {
            return true;
        }
        return false;
    }

    public function remove_invoice_in_collissimo_label($optionValue)
    {
        return 'no';
    }

    public function generatePdf(TW_Shipping $shipping, $shipmentDetails, $outputMode = 'I')
    {
        try {
            $order = wc_get_order($shipping->order_id);
            add_filter('default_option_add_invoice_print_label', array($this, 'remove_invoice_in_collissimo_label'));
            
            $_REQUEST['lpc_tracking_numbers'] = $shipping->label_number;
            ob_start();
            LpcRegister::get('labelPrintAction')->control();
            $colissimoPdf = ob_get_clean();
            unset($_REQUEST['lpc_tracking_numbers']);

            $labelFilename = $this->getGeneratedLabelFilename($order);
            if(file_exists($labelFilename)){
               unlink($labelFilename); 
            }
            file_put_contents($labelFilename, $colissimoPdf);

            $this->generateSentArticlesList($shipping, $shipmentDetails, 'F');
            $invoiceFilename = $this->getArticlesListFilename($order);

            $pdf = new \setasign\Fpdi\Tcpdf\Fpdi;

            //import Label
            $pageCount = $pdf->setSourceFile($labelFilename);
            for($pageNo=1; $pageNo<=$pageCount; $pageNo++) {
                $pageId = $pdf->importPage($pageNo);
                $s = $pdf->getTemplatesize($pageId);
                $pdf->AddPage($s['orientation'], $s);
                $pdf->useImportedPage($pageId);
            }

            $pageCount = $pdf->setSourceFile($invoiceFilename);
            for($pageNo=1; $pageNo<=$pageCount; $pageNo++) {
                $pageId = $pdf->importPage($pageNo);
                $s = $pdf->getTemplatesize($pageId);
                $pdf->AddPage($s['orientation'], $s);
                $pdf->useImportedPage($pageId);
            }

            remove_filter('default_option_add_invoice_print_label', array($this, 'remove_invoice_in_collissimo_label'));
            $pdf->Output('generated.pdf', $outputMode);
        } catch (Exception $ex) {}
    }

    public function generateShipmentTrackingFromShipmentInfo(TW_Shipping $shipping, $shipmentDetails, $useInsurance)
    {
        $logger = wc_get_logger();
        $shipingRepository = TW_Factory::getInstance()->getClass(TW_Shipping_Repository::class);

        $generationSuccess = false;
        $generationMsg = null;
        $generatedLabel = null;

        /**
         * attention pour lpc les quantités doivent impérativement être définie en float
         */
        if(strchr($shipping->carrier, 'lpc_') !== false) {
            $now = new DateTime();
            $order = wc_get_order($shipping->order_id);
            $order->get_shipping_methods();

            $previousShippingMethod = $this->_getPreviousShippingMethod($order);            
            $totalWeight = $shipping->get_package_weight($shipmentDetails);
            list($items, $assuranceAmount) = $this->_getItemsListAndInsuranceAmount($shipping, $shipmentDetails);
            
            if($previousShippingMethod !== null) {
                $this->_setNewShippingMethod($shipping, $previousShippingMethod);
            }

            if($shipping->expedition_type == 'outward') {
                try {
                    $labelGenerator = LpcRegister::get('labelGenerationOutward');
                    $labelQueries = LpcRegister::get('labelQueries');
                    
                    $params = [
                        'totalWeight' => $totalWeight,
                        'items' => $items
                    ];
                    if($useInsurance === 'yes') {
                        $params['useInsurance'] = $useInsurance;
                        $params['insuranceAmount'] = $assuranceAmount;
                    }

                    $generationSuccess = $labelGenerator->generate($order, $params);
                    if($generationSuccess == false) {
                        throw new Exception("label_generation_error");
                    }

                    $shipping->label_generated = 1;
                    $shipping->label_generation_time = $now->format('Y-m-d H:i:s');
                    $shipping->label_number = $order->get_meta('lpc_outward_parcel_number', true);
                    $shipping->label_tracking_link = $labelQueries->getOutwardLabelLink(
                        $shipping->order_id, 
                        $shipping->label_number
                    );
                    $shipping->label_print_link = LpcRegister::get('labelPrintAction')->getUrlForTrackingNumbers([$shipping->label_number]);
                    $shipingRepository->update_shipping($shipping);

                    if($this->isOrderFullyShipped($order)){
                        $order->set_status("wc-shipped");
                    } else {
                        $order->set_status("wc-partially-shipped");
                    }
                    $order->save();
                } catch(Exception $ex) {
                    $failedMessage = get_option('lpc_orders_outward_parcel_failed');
                    if($failedMessage !== false && isset($failedMessage[$shipping->order_id]) && isset($failedMessage[$shipping->order_id]['message'])) {
                        $generationMsg = $failedMessage[$shipping->order_id]['message'];
                    }

                    $shipping->label_generated = 0;
                    $shipping->label_generation_time = $now->format('Y-m-d H:i:s');
                    $shipingRepository->update_shipping($shipping);

                    $logger->error('shipment generation failed ' . $shipping->expedition_id);
                }
            } else if($shipping->expedition_type == 'inward') {
                try {
                    $labelGenerator = LpcRegister::get('labelGenerationInward');
                    $labelQueries = LpcRegister::get('labelQueries');
                    
                    $params = [
                        'totalWeight' => $totalWeight,
                        'items' => $items
                    ];
                    if($useInsurance === 'yes') {
                        $params['useInsurance'] = $useInsurance;
                        $params['insuranceAmount'] = $assuranceAmount;
                    }

                    $generationSuccess = $labelGenerator->generate($order, $params);
                    if($generationSuccess == false) {
                        throw new Exception("label_generation_error");
                    }

                    $shipping->label_generated = 1;
                    $shipping->label_generation_time = $now->format('Y-m-d H:i:s');
                    $shipping->label_number = $order->get_meta('lpc_inward_parcel_number', true);
                    $shipping->label_tracking_link = null;
                    $shipping->label_print_link = LpcRegister::get('labelPrintAction')->getUrlForTrackingNumbers([$shipping->label_number]);

                    $shipingRepository->update_shipping($shipping);
                } catch(Exception $ex) {
                    $failedMessage = get_option('lpc_orders_inward_parcel_failed');
                    if($failedMessage !== false && isset($failedMessage[$shipping->order_id]) && isset($failedMessage[$shipping->order_id]['message'])) {
                        $generationMsg = $failedMessage[$shipping->order_id]['message'];
                    }

                    $shipping->label_generated = 0;
                    $shipping->label_generation_time = $now->format('Y-m-d H:i:s');
                    $shipingRepository->update_shipping($shipping);
                    
                    $logger->error('shipment generation failed ' . $shipping->expedition_id);
                }
            }

            if($previousShippingMethod !== null) {
                $this->_restorePreviousShippingMethod($previousShippingMethod);
            }
            return [$generationSuccess, $generationMsg, $shipping];
        }
    }
}