<?php
if(!defined('ABSPATH')){
    die;
}

function tw_override_store_colissimo_address_options($value, $option_name, $value_if_not_found)
{
    $mappings = array(
        'lpc_origin_company_name' => 'STORE_COMPANYNAME',
        'lpc_origin_address_line_1' => 'STORE_STREET',
        'lpc_origin_address_line_2' => 'STORE_STREET2',
        'lpc_origin_address_country' => 'STORE_COUNTRYCODE',
        'lpc_origin_address_city' => 'STORE_CITY',
        'lpc_origin_address_zipcode' => 'STORE_ZIPCODE',
        'lpc_origin_email' => 'STORE_EMAIL',
        'lpc_origin_phone' => 'STORE_PHONE'
    );

    if(in_array($option_name, array_keys($mappings))){
        if(defined($mappings[$option_name]) && !empty(constant($mappings[$option_name]))) {
            $value = constant($mappings[$option_name]);
        }
    }
    return $value;
}
add_filter('pre_option', 'tw_override_store_colissimo_address_options', PHP_INT_MAX, 3);

function tw_override_store_colissimo_api_credentials($value, $option_name, $value_if_not_found)
{
    $mappings = array(
        'lpc_credentials_type' => 'COLISSIMO_CREDENTIALS_TYPE',
        'lpc_apikey' => 'COLISSIMO_API_KEY'
    );

    if(in_array($option_name, array_keys($mappings))){
        if(defined($mappings[$option_name]) && !empty(constant($mappings[$option_name]))) {
            $value = constant($mappings[$option_name]);
        }
    }
    return $value;
}
add_filter('pre_option', 'tw_override_store_colissimo_api_credentials', PHP_INT_MAX, 3);

//il est aussi possible d'utiliser cette fonction pour modifier les prix
function tw_check_colissimo_package_dimensions($rates, $package)
{
    $logger = wc_get_logger();

    $seuilColisVolumineuxColissimo = 150;
    $maxDimensionsInCm = 200;
    $additionalCostForOverweightPackage = 6.0;
    $packageIsOverWeight = false;
    $packageIsShippableByColissimo = true;

    foreach($package['contents'] as $item) {
        $product = wc_get_product($item['product_id']);

        $item_length = 0;
        $item_width = 0;
        $item_height = 0;

        if(!empty($product)){
            $item_length = !empty($product->get_length()) ? (float)$product->get_length() : 0;
            $item_width = !empty($product->get_width()) ? (float)$product->get_width() : 0;
            $item_height = !empty($product->get_height()) ? (float)$product->get_height() : 0;

            if(($item_length + $item_width + $item_height) >= $seuilColisVolumineuxColissimo) {
                $packageIsOverWeight = true;
            }

            if(($item_length + $item_width + $item_height) > $maxDimensionsInCm) {
                $packageIsShippableByColissimo = false;
                break;
            }
        }
    }

    if($packageIsShippableByColissimo === false) {
        $logger->info('Suppresion de la méthode d\'envoi colissimo car dimensions du produit ' . $product->get_id() . ' supérieur à la limite collissimo');
        $rates = array_filter($rates, function($rate){
            return strchr($rate->get_id(), 'lpc') === false;
        });
    }

    if($packageIsOverWeight === true) {
        $logger->info('Ajout de la surtaxe pour expédition de colis volumineux ' . $product->get_id() . ' : surtaxe ' . $additionalCostForOverweightPackage);
        foreach($rates as &$rate) {
            if(strchr($rate->get_id(), 'lpc') !== false && $packageIsOverWeight == true) {
                $cost = (float)$rate->get_cost() + $additionalCostForOverweightPackage;
                $rate->set_cost($cost);
            }
        }
    }

    return $rates;
}
add_filter('woocommerce_package_rates', 'tw_check_colissimo_package_dimensions', PHP_INT_MAX, 2);