<?php
if(!defined('ABSPATH')){
    die;
}

class TW_External_Stock_Fournisseur1_Handler extends TW_External_Stock_Handler {

    public function canHandle(WC_Product $product)
    {
       if($product->get_supplier_data('supplier_name') !== null && strtolower($product->get_supplier_data('supplier_name')) == 'fournisseur1') {
            return true;
       }
       return false;
    }

    public function getProductStocks($products, $forceRefresh = true)
    {
        $totalStocks = [];
        $refeshedStocks = [];

        $now = new \DateTime();
        $stockRepository = TW_Factory::getInstance()->getClass(TW_External_Stock_Repository::class);
        $productIdsToRetrieve = [];

        $existingStocks = $stockRepository->getStocks($products);
        foreach($existingStocks as $stock) {
            $lastChecked = Datetime::createFromFormat('Y-m-d H:i:s', $stock['last_checked']);
            if($forceRefresh == true || tw_dateinterval_difference_in_seconds($lastChecked, $now) > $this->maxDelayBeforeUpdateInSeconds){
                $productIdsToRetrieve[] = $stock['product_id'];
            }

            $totalStocks[$stock['product_id']] = $stock['quantity'];
        }

        foreach($products as $product) {
            if(!isset($existingStocks[$product->get_id()])){
                $productIdsToRetrieve[] = $product->get_id();
            }
        }

        $refeshedStocks = $this->_retrieveProductStocks($productIdsToRetrieve);
        foreach($refeshedStocks as $id => $stock) {
            $totalStocks[$id] = $stock;
        }

        return [$totalStocks, $refeshedStocks];
    }

    private function _retrieveProductStocks($productIds)
    {
        $webserviceUrl = "http://local.platformfournisseur1.fr/api/stocks";
        $refreshedStock = [];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $webserviceUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $res = curl_exec($ch);

		$code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        if($code == 200) {
            $res = json_decode($res, true);
            foreach($res['member'] as $info) {
                if(in_array($info['productId'], $productIds)){
                    $refreshedStock[$info['productId']] = $info['stockedQuantity'];
                }
            }
        }

		curl_close($ch);
        return $refreshedStock;
    }
}