<?php
use Elementor\Widget_Base;

$GLOBALS['tw_custom_queries'] = [
    'tw_related_product' => __('Produit liés (requête personnalisée)', 'tw-theme')
];

function tw_loop_add_query(Widget_Base $widget){
    $queriesTypes = ['post_query_post_type','product_query_post_type','post_taxonomy_query_post_type','product_taxonomy_query_post_type'];

    foreach($queriesTypes as $type) {
        $ctrls = $widget->get_controls($type);
        if(isset($ctrls) && is_array($ctrls) && isset($ctrls['options'])) {
            foreach($GLOBALS['tw_custom_queries'] as $queryValue => $queryLabel) {
                $options = $ctrls['options'];
                $options[$queryValue] = $queryLabel;

                $widget->update_control($type, [
                    'options' => $options
                ]);
            }
        }
    }
}
add_action('elementor/element/loop-carousel/section_query/after_section_start', 'tw_loop_add_query', PHP_INT_MAX);
add_action('elementor/element/loop-grid/section_query/after_section_start', 'tw_loop_add_query', PHP_INT_MAX);

function tw_custom_query(WP_Query $query, Widget_Base $widget){
    $customQuery = null;
    $skin = $widget->get_settings('_skin');

    if($skin !== null 
        && $widget->get_settings($skin . '_query_post_type') !== null
        && isset($GLOBALS['tw_custom_queries'][$widget->get_settings($skin . '_query_post_type')])
    ) {
        $customQuery = $widget->get_settings($skin . '_query_post_type');

        if($customQuery == 'tw_related_product') {
            $product = wc_get_product($GLOBALS['wp_query']->post);
            if($product instanceof WC_Product) {
                $sex = $product->getCustomAttributesOrTaxonomy('sex', 'SLUG');
                $size = $product->getCustomAttributesOrTaxonomy('size', 'SLUG');

                $categoriesSlugs = [];
                $categories = TW_Factory::getInstance()->getClass(TW_Product_Repository::class)->getCategoriesIdsWithChild($product->get_category_ids());
                foreach($categories as $item) {
                    $categoriesSlugs[] = $item['slug'];
                }

                $query_args = [
                    'post_type' => 'product',
                    'meta_query' => [
                        [
                            'field' => '_stock_status',
                            'value' => ['instock','onbackorder']
                        ]
                    ],
                    'tax_query' => [
                        [
                            'alias' => 'sex',
                            'taxonomy' => 'pa_sex',
                            'field' => 'slug',
                            'terms' => $sex
                        ],
                        [
                            'alias' => 'size',
                            'taxonomy' => 'pa_size',
                            'field' => 'slug',
                            'terms' => $size
                        ],
                        [
                            'alias' => 'category',
                            'taxonomy' => 'product_cat',
                            'field' => 'slug',
                            'terms' => $categoriesSlugs
                        ]
                    ],
                    'orderby' => ['wp.post_title' => 'ASC'],
                    'posts_per_page' => 8,
                    'offset' => 0
                ];

                $tw_query = new TW_WP_Query($query_args);
                $tw_query->hydrateWpQuery($query);
            }
        }
    }
}   
add_action('elementor/query/query_results', 'tw_custom_query', PHP_INT_MAX, 2);