<?php

use Automattic\WooCommerce\Checkout\Helpers\ReserveStock;


class Tests_Shipping extends WP_UnitTestCase {


	/**
	 * ATTENTION AU NIVEAU DE LA TEST SUITE SI WP_RUN_CORE_TESTS = 1 les post types sont resets entre chaque test
	 */
    public static function wpSetUpBeforeClass() {

		$pluginsToActivate = [
			dirname(__DIR__, 4) . '/woocommerce/woocommerce.php',
			dirname(__DIR__, 4) . '/tw-core/tw-core.php',
			dirname(__DIR__, 4) . '/tw-core/classes/tw_product_simple.php'    
		];
		foreach($pluginsToActivate as $plugin) {
			require_once $plugin;
		}

		require_once dirname(__DIR__, 1) . '/includes/tw_include/testStockHandler.php';
		do_action('init');
    }
	

	public function tear_down(){
		parent::tear_down();

		$testProducts = new WC_Product_Query([
			'name' => 'test_product'
		]);
		$testProducts->get_products();
		foreach($testProducts as $item) {
			$item->delete();
		}
		wc_delete_product_transients();
	}
	
	private function create_order(){

    }
}